/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import java.io.IOException;

public final class Log4jStackTraceElementDeserializer
extends StdScalarDeserializer<StackTraceElement> {
    private static final long serialVersionUID = 1L;

    public Log4jStackTraceElementDeserializer() {
        super(StackTraceElement.class);
    }

    @Override
    public StackTraceElement deserialize(JsonParser jp2, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken t2 = jp2.getCurrentToken();
        if (t2 == JsonToken.START_OBJECT) {
            String className = null;
            String methodName = null;
            String fileName = null;
            int lineNumber = -1;
            while ((t2 = jp2.nextValue()) != JsonToken.END_OBJECT) {
                String propName = jp2.getCurrentName();
                if ("class".equals(propName)) {
                    className = jp2.getText();
                    continue;
                }
                if ("file".equals(propName)) {
                    fileName = jp2.getText();
                    continue;
                }
                if ("line".equals(propName)) {
                    if (t2.isNumeric()) {
                        lineNumber = jp2.getIntValue();
                        continue;
                    }
                    try {
                        lineNumber = Integer.parseInt(jp2.getText().trim());
                        continue;
                    }
                    catch (NumberFormatException e2) {
                        throw JsonMappingException.from(jp2, "Non-numeric token (" + (Object)((Object)t2) + ") for property 'line'", (Throwable)e2);
                    }
                }
                if ("method".equals(propName)) {
                    methodName = jp2.getText();
                    continue;
                }
                if ("nativeMethod".equals(propName)) continue;
                this.handleUnknownProperty(jp2, ctxt, this._valueClass, propName);
            }
            return new StackTraceElement(className, methodName, fileName, lineNumber);
        }
        throw ctxt.mappingException(this._valueClass, t2);
    }
}

