/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime.tree.xpath;

import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.LexerNoViableAltException;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.Vocabulary;
import org.antlr.v4.runtime.VocabularyImpl;
import org.antlr.v4.runtime.atn.ATN;
import org.antlr.v4.runtime.misc.Interval;

public class XPathLexer
extends Lexer {
    public static final int TOKEN_REF = 1;
    public static final int RULE_REF = 2;
    public static final int ANYWHERE = 3;
    public static final int ROOT = 4;
    public static final int WILDCARD = 5;
    public static final int BANG = 6;
    public static final int ID = 7;
    public static final int STRING = 8;
    public static String[] modeNames = new String[]{"DEFAULT_MODE"};
    public static final String[] ruleNames = new String[]{"ANYWHERE", "ROOT", "WILDCARD", "BANG", "ID", "NameChar", "NameStartChar", "STRING"};
    private static final String[] _LITERAL_NAMES = new String[]{null, null, null, "'//'", "'/'", "'*'", "'!'"};
    private static final String[] _SYMBOLIC_NAMES = new String[]{null, "TOKEN_REF", "RULE_REF", "ANYWHERE", "ROOT", "WILDCARD", "BANG", "ID", "STRING"};
    public static final Vocabulary VOCABULARY = new VocabularyImpl(_LITERAL_NAMES, _SYMBOLIC_NAMES);
    @Deprecated
    public static final String[] tokenNames = new String[_SYMBOLIC_NAMES.length];
    protected int line = 1;
    protected int charPositionInLine = 0;

    @Override
    public String getGrammarFileName() {
        return "XPathLexer.g4";
    }

    @Override
    public String[] getRuleNames() {
        return ruleNames;
    }

    @Override
    public String[] getModeNames() {
        return modeNames;
    }

    @Override
    @Deprecated
    public String[] getTokenNames() {
        return tokenNames;
    }

    @Override
    public Vocabulary getVocabulary() {
        return VOCABULARY;
    }

    @Override
    public ATN getATN() {
        return null;
    }

    public XPathLexer(CharStream input) {
        super(input);
    }

    @Override
    public Token nextToken() {
        this._tokenStartCharIndex = this._input.index();
        CommonToken t2 = null;
        block7: while (t2 == null) {
            switch (this._input.LA(1)) {
                case 47: {
                    this.consume();
                    if (this._input.LA(1) == 47) {
                        this.consume();
                        t2 = new CommonToken(3, "//");
                        continue block7;
                    }
                    t2 = new CommonToken(4, "/");
                    continue block7;
                }
                case 42: {
                    this.consume();
                    t2 = new CommonToken(5, "*");
                    continue block7;
                }
                case 33: {
                    this.consume();
                    t2 = new CommonToken(6, "!");
                    continue block7;
                }
                case 39: {
                    String s2 = this.matchString();
                    t2 = new CommonToken(8, s2);
                    continue block7;
                }
                case -1: {
                    return new CommonToken(-1, "<EOF>");
                }
            }
            if (this.isNameStartChar(this._input.LA(1))) {
                String id2 = this.matchID();
                if (Character.isUpperCase(id2.charAt(0))) {
                    t2 = new CommonToken(1, id2);
                    continue;
                }
                t2 = new CommonToken(2, id2);
                continue;
            }
            throw new LexerNoViableAltException(this, this._input, this._tokenStartCharIndex, null);
        }
        t2.setStartIndex(this._tokenStartCharIndex);
        t2.setCharPositionInLine(this._tokenStartCharIndex);
        t2.setLine(this.line);
        return t2;
    }

    public void consume() {
        int curChar = this._input.LA(1);
        if (curChar == 10) {
            ++this.line;
            this.charPositionInLine = 0;
        } else {
            ++this.charPositionInLine;
        }
        this._input.consume();
    }

    @Override
    public int getCharPositionInLine() {
        return this.charPositionInLine;
    }

    public String matchID() {
        int start = this._input.index();
        this.consume();
        while (this.isNameChar(this._input.LA(1))) {
            this.consume();
        }
        return this._input.getText(Interval.of(start, this._input.index() - 1));
    }

    public String matchString() {
        int start = this._input.index();
        this.consume();
        while (this._input.LA(1) != 39) {
            this.consume();
        }
        this.consume();
        return this._input.getText(Interval.of(start, this._input.index() - 1));
    }

    public boolean isNameChar(int c2) {
        return Character.isUnicodeIdentifierPart(c2);
    }

    public boolean isNameStartChar(int c2) {
        return Character.isUnicodeIdentifierStart(c2);
    }

    static {
        for (int i2 = 0; i2 < tokenNames.length; ++i2) {
            XPathLexer.tokenNames[i2] = VOCABULARY.getLiteralName(i2);
            if (tokenNames[i2] == null) {
                XPathLexer.tokenNames[i2] = VOCABULARY.getSymbolicName(i2);
            }
            if (tokenNames[i2] != null) continue;
            XPathLexer.tokenNames[i2] = "<INVALID>";
        }
    }
}

