/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;
import kotlin.Metadata;
import kotlin.collections.AbstractList;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00020\u00012\u00060\u0003j\u0002`\u0004:\u0001\u0015B\u001f\b\u0002\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0011\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u000eH\u0096\u0002R\u001e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0006X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0016"}, d2={"Lokio/Options;", "Lkotlin/collections/AbstractList;", "Lokio/ByteString;", "Ljava/util/RandomAccess;", "Lkotlin/collections/RandomAccess;", "byteStrings", "", "trie", "", "([Lokio/ByteString;[I)V", "getByteStrings$okio", "()[Lokio/ByteString;", "[Lokio/ByteString;", "size", "", "getSize", "()I", "getTrie$okio", "()[I", "get", "index", "Companion", "okio"})
public final class Options
extends AbstractList<ByteString>
implements RandomAccess {
    @NotNull
    private final ByteString[] byteStrings;
    @NotNull
    private final int[] trie;
    public static final Companion Companion = new Companion(null);

    @Override
    public int getSize() {
        return this.byteStrings.length;
    }

    @Override
    @NotNull
    public ByteString get(int index) {
        return this.byteStrings[index];
    }

    @NotNull
    public final ByteString[] getByteStrings$okio() {
        return this.byteStrings;
    }

    @NotNull
    public final int[] getTrie$okio() {
        return this.trie;
    }

    private Options(ByteString[] byteStrings, int[] trie) {
        this.byteStrings = byteStrings;
        this.trie = trie;
    }

    public /* synthetic */ Options(ByteString[] byteStrings, int[] trie, DefaultConstructorMarker $constructor_marker) {
        this(byteStrings, trie);
    }

    @JvmStatic
    @NotNull
    public static final Options of(ByteString ... byteStrings) {
        return Companion.of(byteStrings);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JT\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00052\b\b\u0002\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\b\u0002\u0010\u0011\u001a\u00020\r2\b\b\u0002\u0010\u0012\u001a\u00020\r2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\u000fH\u0002J!\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u0016\"\u00020\u0010H\u0007\u00a2\u0006\u0002\u0010\u0017R\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lokio/Options$Companion;", "", "()V", "intCount", "", "Lokio/Buffer;", "getIntCount", "(Lokio/Buffer;)J", "buildTrieRecursive", "", "nodeOffset", "node", "byteStringOffset", "", "byteStrings", "", "Lokio/ByteString;", "fromIndex", "toIndex", "indexes", "of", "Lokio/Options;", "", "([Lokio/ByteString;)Lokio/Options;", "okio"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final Options of(ByteString ... byteStrings) {
            int n2;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(byteStrings, "byteStrings");
            ByteString[] byteStringArray = byteStrings;
            boolean bl2 = false;
            if (byteStringArray.length == 0) {
                return new Options(new ByteString[0], new int[]{0, -1}, null);
            }
            List<ByteString> list = ArraysKt.toMutableList(byteStrings);
            CollectionsKt.sort(list);
            ByteString[] $this$map$iv = byteStrings;
            boolean $i$f$map = false;
            ByteString[] byteStringArray2 = $this$map$iv;
            ByteString[] destination$iv$iv = (ByteString[])new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            void var9_19 = $this$mapTo$iv$iv;
            int n3 = ((void)var9_19).length;
            for (int i2 = 0; i2 < n3; ++i2) {
                void item$iv$iv;
                void var13_28 = item$iv$iv = var9_19[i2];
                ByteString[] byteStringArray3 = destination$iv$iv;
                boolean bl3 = false;
                Integer n4 = -1;
                byteStringArray3.add(n4);
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Integer[] integerArray = thisCollection$iv.toArray(new Integer[0]);
            if (integerArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            List<Integer> indexes = CollectionsKt.mutableListOf(Arrays.copyOf(integerArray, integerArray.length));
            ByteString[] $this$forEachIndexed$iv22 = byteStrings;
            boolean $i$f$forEachIndexed = false;
            int index$iv2 = 0;
            for (ByteString item$iv : $this$forEachIndexed$iv22) {
                void byteString;
                int n5 = index$iv2++;
                ByteString byteString2 = item$iv;
                int callerIndex = n5;
                boolean bl4 = false;
                int sortedIndex = CollectionsKt.binarySearch$default(list, (Comparable)byteString, 0, 0, 6, null);
                indexes.set(sortedIndex, callerIndex);
            }
            boolean $this$forEachIndexed$iv22 = list.get(0).size() > 0;
            $i$f$forEachIndexed = false;
            index$iv2 = 0;
            if (!$this$forEachIndexed$iv22) {
                boolean bl5 = false;
                String index$iv2 = "the empty byte string is not a supported option";
                throw (Throwable)new IllegalArgumentException(index$iv2.toString());
            }
            for (int a2 = 0; a2 < list.size(); ++a2) {
                ByteString byteString;
                ByteString prefix = list.get(a2);
                int b2 = a2 + 1;
                while (b2 < list.size() && (byteString = list.get(b2)).startsWith(prefix)) {
                    int n6 = byteString.size() != prefix.size() ? 1 : 0;
                    n2 = 0;
                    n3 = 0;
                    if (n6 == 0) {
                        boolean bl6 = false;
                        String string = "duplicate option: " + byteString;
                        throw (Throwable)new IllegalArgumentException(string.toString());
                    }
                    if (((Number)indexes.get(b2)).intValue() > ((Number)indexes.get(a2)).intValue()) {
                        list.remove(b2);
                        indexes.remove(b2);
                        continue;
                    }
                    ++b2;
                }
            }
            Buffer trieBytes = new Buffer();
            okio.Options$Companion.buildTrieRecursive$default(this, 0L, trieBytes, 0, list, 0, 0, indexes, 53, null);
            int[] trie = new int[(int)this.getIntCount(trieBytes)];
            int i3 = 0;
            while (!trieBytes.exhausted()) {
                trie[i3++] = trieBytes.readInt();
            }
            ByteString[] byteStringArray4 = byteStrings;
            n2 = 0;
            ByteString[] byteStringArray5 = Arrays.copyOf(byteStringArray4, byteStringArray4.length);
            Intrinsics.checkNotNullExpressionValue(byteStringArray5, "java.util.Arrays.copyOf(this, size)");
            return new Options(byteStringArray5, trie, null);
        }

        /*
         * WARNING - void declaration
         */
        private final void buildTrieRecursive(long nodeOffset, Buffer node, int byteStringOffset, List<? extends ByteString> byteStrings, int fromIndex, int toIndex, List<Integer> indexes) {
            void i2;
            int n2;
            int n3 = fromIndex < toIndex ? 1 : 0;
            int n4 = 0;
            boolean bl2 = false;
            bl2 = false;
            boolean bl3 = false;
            if (n3 == 0) {
                boolean bl4 = false;
                String string = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            n3 = fromIndex;
            n4 = toIndex;
            while (n3 < n4) {
                void i3;
                bl2 = byteStrings.get((int)i3).size() >= byteStringOffset;
                bl3 = false;
                boolean bl5 = false;
                bl5 = false;
                n2 = 0;
                if (!bl2) {
                    boolean bl6 = false;
                    String string = "Failed requirement.";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                ++i3;
            }
            int fromIndex2 = fromIndex;
            ByteString from = byteStrings.get(fromIndex2);
            ByteString to = byteStrings.get(toIndex - 1);
            int prefixIndex = -1;
            if (byteStringOffset == from.size()) {
                prefixIndex = ((Number)indexes.get(fromIndex2)).intValue();
                from = byteStrings.get(++fromIndex2);
            }
            if (from.getByte(byteStringOffset) != to.getByte(byteStringOffset)) {
                int other$iv;
                byte rangeByte;
                int selectChoiceCount = 1;
                n2 = fromIndex2 + 1;
                int n5 = toIndex;
                while (n2 < n5) {
                    if (byteStrings.get((int)(i2 - true)).getByte(byteStringOffset) != byteStrings.get((int)i2).getByte(byteStringOffset)) {
                        ++selectChoiceCount;
                    }
                    ++i2;
                }
                long childNodesOffset = nodeOffset + this.getIntCount(node) + (long)2 + (long)(selectChoiceCount * 2);
                node.writeInt(selectChoiceCount);
                node.writeInt(prefixIndex);
                int n6 = fromIndex2;
                int n7 = toIndex;
                while (n6 < n7) {
                    void i4;
                    rangeByte = byteStrings.get((int)i4).getByte(byteStringOffset);
                    if (i4 == fromIndex2 || rangeByte != byteStrings.get((int)(i4 - true)).getByte(byteStringOffset)) {
                        void $this$and$iv;
                        byte by2 = rangeByte;
                        other$iv = 255;
                        boolean $i$f$and = false;
                        node.writeInt($this$and$iv & other$iv);
                    }
                    ++i4;
                }
                Buffer childNodes = new Buffer();
                int rangeStart = fromIndex2;
                while (rangeStart < toIndex) {
                    rangeByte = byteStrings.get(rangeStart).getByte(byteStringOffset);
                    int rangeEnd = toIndex;
                    other$iv = rangeStart + 1;
                    int n8 = toIndex;
                    while (other$iv < n8) {
                        void i5;
                        if (rangeByte != byteStrings.get((int)i5).getByte(byteStringOffset)) {
                            rangeEnd = i5;
                            break;
                        }
                        ++i5;
                    }
                    if (rangeStart + 1 == rangeEnd && byteStringOffset + 1 == byteStrings.get(rangeStart).size()) {
                        node.writeInt(((Number)indexes.get(rangeStart)).intValue());
                    } else {
                        node.writeInt(-1 * (int)(childNodesOffset + this.getIntCount(childNodes)));
                        this.buildTrieRecursive(childNodesOffset, childNodes, byteStringOffset + 1, byteStrings, rangeStart, rangeEnd, indexes);
                    }
                    rangeStart = rangeEnd;
                }
                node.writeAll(childNodes);
            } else {
                boolean i6;
                int scanByteCount = 0;
                int childNodesOffset = byteStringOffset;
                int childNodes = from.size();
                int n9 = to.size();
                byte rangeByte = 0;
                int n10 = Math.min(childNodes, n9);
                while (childNodesOffset < n10 && from.getByte((int)i2) == to.getByte((int)i2)) {
                    ++scanByteCount;
                    ++i2;
                }
                long childNodesOffset2 = nodeOffset + this.getIntCount(node) + (long)2 + (long)scanByteCount + 1L;
                node.writeInt(-scanByteCount);
                node.writeInt(prefixIndex);
                childNodes = byteStringOffset;
                n9 = byteStringOffset + scanByteCount;
                while (childNodes < n9) {
                    void $this$and$iv;
                    rangeByte = from.getByte(i6 ? 1 : 0);
                    int other$iv = 255;
                    boolean $i$f$and = false;
                    node.writeInt($this$and$iv & other$iv);
                    i6 += 1;
                }
                if (fromIndex2 + 1 == toIndex) {
                    i6 = byteStringOffset + scanByteCount == byteStrings.get(fromIndex2).size();
                    n9 = 0;
                    boolean bl7 = false;
                    bl7 = false;
                    boolean bl8 = false;
                    if (!i6) {
                        boolean bl9 = false;
                        String string = "Check failed.";
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                    node.writeInt(((Number)indexes.get(fromIndex2)).intValue());
                } else {
                    Buffer childNodes2 = new Buffer();
                    node.writeInt(-1 * (int)(childNodesOffset2 + this.getIntCount(childNodes2)));
                    this.buildTrieRecursive(childNodesOffset2, childNodes2, byteStringOffset + scanByteCount, byteStrings, fromIndex2, toIndex, indexes);
                    node.writeAll(childNodes2);
                }
            }
        }

        static /* synthetic */ void buildTrieRecursive$default(Companion companion, long l2, Buffer buffer, int n2, List list, int n3, int n4, List list2, int n5, Object object) {
            if ((n5 & 1) != 0) {
                l2 = 0L;
            }
            if ((n5 & 4) != 0) {
                n2 = 0;
            }
            if ((n5 & 0x10) != 0) {
                n3 = 0;
            }
            if ((n5 & 0x20) != 0) {
                n4 = list.size();
            }
            companion.buildTrieRecursive(l2, buffer, n2, list, n3, n4, list2);
        }

        private final long getIntCount(Buffer $this$intCount) {
            return $this$intCount.size() / (long)4;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

