/*
 * Decompiled with CFR 0.152.
 */
package liquibase.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexMatcher {
    private String text;
    private Pattern[] patterns;
    private boolean allMatched;

    public RegexMatcher(String text, String[] regexToMatch) {
        assert (text != null && regexToMatch != null);
        this.text = text;
        this.patterns = new Pattern[regexToMatch.length];
        for (int i2 = 0; i2 < regexToMatch.length; ++i2) {
            this.patterns[i2] = Pattern.compile(regexToMatch[i2], 10);
        }
        this.allMatched = this.checkMatchingInSequentialOrder();
    }

    private boolean checkMatchingInSequentialOrder() {
        int index = 0;
        for (Pattern p2 : this.patterns) {
            Matcher m3 = p2.matcher(this.text.substring(index));
            if (!m3.find()) {
                return false;
            }
            index += m3.end();
        }
        return true;
    }

    public boolean allMatchedInSequentialOrder() {
        return this.allMatched;
    }
}

