/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sdk;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.sdk.convert.ConvertCommand;
import liquibase.util.StringUtil;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class Main {
    private boolean debug;
    private CommandLine globalArguments;
    private String command;
    private List<String> commandArgs = new ArrayList<String>();
    private Options globalOptions = new Options();

    public static void main(String[] args2) {
        Main main = new Main();
        main.header("Liquibase SDK");
        try {
            main.init(args2);
            if (main.command == null) {
                throw new UserError("No command passed");
            }
            if ("help".equals(main.command)) {
                main.printHelp();
                return;
            }
            GnuParser commandParser = new GnuParser();
            if (!"convert".equals(main.command)) {
                throw new UserError("Unknown command: " + main.command);
            }
            ConvertCommand command = new ConvertCommand();
            Options options = new Options();
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Original changelog");
            OptionBuilder.isRequired();
            options.addOption(OptionBuilder.create((String)"src"));
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Output changelog");
            OptionBuilder.isRequired();
            options.addOption(OptionBuilder.create((String)"out"));
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Classpath");
            options.addOption(OptionBuilder.create((String)"classpath"));
            CommandLine commandArguments = commandParser.parse(options, main.commandArgs.toArray(new String[main.commandArgs.size()]));
            command.setSrc(commandArguments.getOptionValue("src"));
            command.setOut(commandArguments.getOptionValue("out"));
            command.setClasspath(commandArguments.getOptionValue("classpath"));
            command.execute();
            main.divider();
            main.out("Command executed successfully");
        }
        catch (UserError userError) {
            main.out("");
            main.header("ERROR EXECUTING COMMAND");
            main.out(userError.getMessage());
            main.out("");
            main.out("");
            return;
        }
        catch (Throwable exception) {
            System.out.println("Unexpected error: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    public void init(String[] args2) throws UserError {
        GnuParser globalParser = new GnuParser();
        ArrayList<String> globalArgs = new ArrayList<String>();
        boolean inGlobal = true;
        for (String arg : args2) {
            if (inGlobal) {
                if (arg.startsWith("--")) {
                    globalArgs.add(arg);
                    continue;
                }
                this.command = arg;
                inGlobal = false;
                continue;
            }
            this.commandArgs.add(arg);
        }
        try {
            this.globalArguments = globalParser.parse(this.globalOptions, globalArgs.toArray(new String[globalArgs.size()]));
        }
        catch (ParseException e2) {
            throw new UserError("Error parsing global command line argument: " + e2.getMessage());
        }
    }

    public File getSdkRoot() {
        for (File dir = new File(".").getAbsoluteFile(); dir != null; dir = dir.getParentFile()) {
            if (dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return "liquibase-sdk.bat".equals(name);
                }
            }).length <= 0) continue;
            return dir;
        }
        throw new UnexpectedLiquibaseException("Could not find Liquibase SDK home. Please run liquibase-sdk from the liquibase/sdk directory or one of it's sub directories");
    }

    public String getCommand() {
        return this.command;
    }

    public void header(String ... header) {
        this.divider();
        for (String line : header) {
            System.out.println(line);
        }
        this.divider();
    }

    public void divider() {
        System.out.println("---------------------------------------------------");
    }

    public void out(String message) {
        System.out.println(message);
    }

    public void debug(String message) {
        if (this.debug) {
            System.out.println("DEBUG: " + message);
        }
    }

    public void fatal(String error) throws UserError {
        throw new UserError(error);
    }

    public void fatal(Throwable exception) {
        this.fatal(exception.getMessage(), exception);
    }

    public void fatal(String error, Throwable exception) throws UserError {
        throw new UserError(error, exception);
    }

    public String getPath() {
        Map<String, String> environment = new ProcessBuilder(new String[0]).environment();
        String path = environment.get("Path");
        if (path == null) {
            path = environment.get("PATH");
        }
        if (path == null) {
            path = environment.get("path");
        }
        if (path == null) {
            throw new UnexpectedLiquibaseException("Cannot find path variable in environment. Possible variables are " + StringUtil.join(environment.keySet(), ","));
        }
        return path;
    }

    public String getPath(String ... possibleFileNames) {
        HashSet fileNames = new HashSet();
        for (String dir : this.getPath().split("[:;]")) {
            for (String fileName : possibleFileNames) {
                File file = new File(dir, fileName);
                if (!file.exists()) continue;
                return file.getAbsolutePath();
            }
        }
        return null;
    }

    public void printHelp() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("liquibase-sdk [global options] [command] [command options]", this.globalOptions);
    }

    private static class UserError
    extends RuntimeException {
        private static final long serialVersionUID = 6926190469964122370L;

        public UserError(String message) {
            super(message);
        }

        UserError(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

