/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.search;

import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.search.SearchTerm;

public final class FlagTerm
extends SearchTerm {
    private boolean set;
    private Flags flags;
    private static final long serialVersionUID = -142991500302030647L;

    public FlagTerm(Flags flags, boolean set) {
        this.flags = flags;
        this.set = set;
    }

    public Flags getFlags() {
        return (Flags)this.flags.clone();
    }

    public boolean getTestSet() {
        return this.set;
    }

    @Override
    public boolean match(Message msg) {
        try {
            Flags f2 = msg.getFlags();
            if (this.set) {
                return f2.contains(this.flags);
            }
            Flags.Flag[] sf = this.flags.getSystemFlags();
            for (int i2 = 0; i2 < sf.length; ++i2) {
                if (!f2.contains(sf[i2])) continue;
                return false;
            }
            String[] s2 = this.flags.getUserFlags();
            for (int i3 = 0; i3 < s2.length; ++i3) {
                if (!f2.contains(s2[i3])) continue;
                return false;
            }
            return true;
        }
        catch (MessagingException e2) {
            return false;
        }
        catch (RuntimeException e3) {
            return false;
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FlagTerm)) {
            return false;
        }
        FlagTerm ft2 = (FlagTerm)obj;
        return ft2.set == this.set && ft2.flags.equals(this.flags);
    }

    public int hashCode() {
        return this.set ? this.flags.hashCode() : ~this.flags.hashCode();
    }
}

