/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import java.util.Collection;

public final class ObjectUtil {
    private ObjectUtil() {
    }

    public static <T> T checkNotNull(T arg, String text) {
        if (arg == null) {
            throw new NullPointerException(text);
        }
        return arg;
    }

    public static int checkPositive(int i2, String name) {
        if (i2 <= 0) {
            throw new IllegalArgumentException(name + ": " + i2 + " (expected: > 0)");
        }
        return i2;
    }

    public static long checkPositive(long l2, String name) {
        if (l2 <= 0L) {
            throw new IllegalArgumentException(name + ": " + l2 + " (expected: > 0)");
        }
        return l2;
    }

    public static int checkPositiveOrZero(int i2, String name) {
        if (i2 < 0) {
            throw new IllegalArgumentException(name + ": " + i2 + " (expected: >= 0)");
        }
        return i2;
    }

    public static long checkPositiveOrZero(long l2, String name) {
        if (l2 < 0L) {
            throw new IllegalArgumentException(name + ": " + l2 + " (expected: >= 0)");
        }
        return l2;
    }

    public static int checkInRange(int i2, int start, int end, String name) {
        if (i2 < start || i2 > end) {
            throw new IllegalArgumentException(name + ": " + i2 + " (expected: " + start + "-" + end + ")");
        }
        return i2;
    }

    public static long checkInRange(long l2, long start, long end, String name) {
        if (l2 < start || l2 > end) {
            throw new IllegalArgumentException(name + ": " + l2 + " (expected: " + start + "-" + end + ")");
        }
        return l2;
    }

    public static <T> T[] checkNonEmpty(T[] array, String name) {
        ObjectUtil.checkNotNull(array, name);
        ObjectUtil.checkPositive(array.length, name + ".length");
        return array;
    }

    public static <T extends Collection<?>> T checkNonEmpty(T collection, String name) {
        ObjectUtil.checkNotNull(collection, name);
        ObjectUtil.checkPositive(collection.size(), name + ".size");
        return collection;
    }

    public static int intValue(Integer wrapper, int defaultValue) {
        return wrapper != null ? wrapper : defaultValue;
    }

    public static long longValue(Long wrapper, long defaultValue) {
        return wrapper != null ? wrapper : defaultValue;
    }
}

