/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.rest.tls;

import horse.wtf.nzyme.rest.tls.KeyStoreUtils;
import horse.wtf.nzyme.rest.tls.PemKeyStore;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import javax.net.ssl.SSLContext;
import org.glassfish.grizzly.ssl.SSLContextConfigurator;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;

public class SSLEngineConfiguratorBuilder {
    public static SSLEngineConfigurator build(Path certFile, Path keyFile) throws GeneralSecurityException, IOException {
        if (keyFile == null || !Files.isRegularFile(keyFile, new LinkOption[0]) || !Files.isReadable(keyFile)) {
            throw new InvalidKeyException("Unreadable or missing private key: " + keyFile);
        }
        if (certFile == null || !Files.isRegularFile(certFile, new LinkOption[0]) || !Files.isReadable(certFile)) {
            throw new CertificateException("Unreadable or missing X.509 certificate: " + certFile);
        }
        SSLContextConfigurator sslContextConfigurator = new SSLContextConfigurator();
        char[] password = "".toCharArray();
        KeyStore keyStore = PemKeyStore.buildKeyStore(certFile, keyFile, password);
        sslContextConfigurator.setKeyStorePass(password);
        sslContextConfigurator.setKeyStoreBytes(KeyStoreUtils.getBytes(keyStore, password));
        SSLContext sslContext = sslContextConfigurator.createSSLContext(true);
        return new SSLEngineConfigurator(sslContext, false, false, false);
    }
}

