/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.rest.resources.system;

import com.beust.jcommander.internal.Lists;
import horse.wtf.nzyme.NzymeLeader;
import horse.wtf.nzyme.Registry;
import horse.wtf.nzyme.rest.authentication.Secured;
import horse.wtf.nzyme.rest.responses.system.SystemStatusResponse;
import horse.wtf.nzyme.rest.responses.system.SystemStatusStateResponse;
import horse.wtf.nzyme.rest.responses.system.VersionResponse;
import horse.wtf.nzyme.systemstatus.SystemStatus;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/api/system")
@Secured
@Produces(value={"application/json"})
public class SystemResource {
    @Inject
    private NzymeLeader nzyme;

    @GET
    @Path(value="/status")
    public Response getStatus() {
        List<SystemStatusStateResponse> states = Lists.newArrayList();
        for (SystemStatus.TYPE type : SystemStatus.TYPE.values()) {
            states.add(SystemStatusStateResponse.create(type, this.nzyme.getSystemStatus().isInStatus(type)));
        }
        return Response.ok(SystemStatusResponse.create(states)).build();
    }

    @GET
    @Path(value="/version")
    public Response getVersion() {
        return Response.ok(VersionResponse.create(this.nzyme.getVersion().getVersionString(), this.nzyme.getRegistry().getBool(Registry.KEY.NEW_VERSION_AVAILABLE), this.nzyme.getConfiguration().versionchecksEnabled())).build();
    }
}

