/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.rest.resources;

import com.google.common.collect.Lists;
import horse.wtf.nzyme.NzymeLeader;
import horse.wtf.nzyme.bandits.Bandit;
import horse.wtf.nzyme.bandits.Contact;
import horse.wtf.nzyme.bandits.identifiers.BanditIdentifier;
import horse.wtf.nzyme.bandits.trackers.Tracker;
import horse.wtf.nzyme.bandits.trackers.TrackerManager;
import horse.wtf.nzyme.bandits.trackers.protobuf.TrackerMessage;
import horse.wtf.nzyme.rest.authentication.Secured;
import horse.wtf.nzyme.rest.requests.BanditTrackRequest;
import horse.wtf.nzyme.rest.responses.bandits.ContactResponse;
import horse.wtf.nzyme.rest.responses.trackers.TrackerResponse;
import horse.wtf.nzyme.rest.responses.trackers.TrackersListResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Path(value="/api/trackers")
@Secured
@Produces(value={"application/json"})
public class TrackersResource {
    private static final Logger LOG = LogManager.getLogger(TrackersResource.class);
    @Inject
    private NzymeLeader nzyme;

    @GET
    public Response findAll() {
        ArrayList<TrackerResponse> trackers = Lists.newArrayList();
        for (Tracker tracker : this.nzyme.getTrackerManager().getTrackers().values()) {
            trackers.add(TrackerResponse.create(tracker.getName(), tracker.getVersion(), tracker.getLastSeen(), TrackerManager.decideTrackerState(tracker), tracker.getTrackingMode(), this.buildContactList(this.nzyme.getContactManager().findContactsOfTracker(tracker)), this.nzyme.getGroundStation().trackerHasPendingAnyTrackingRequest(tracker.getName()), tracker.getRssi()));
        }
        return Response.ok(TrackersListResponse.create(this.nzyme.getGroundStation() != null, trackers.size(), trackers)).build();
    }

    @GET
    @Path(value="/show/{name}")
    public Response findTracker(@PathParam(value="name") String name) {
        Map<String, Tracker> trackers = this.nzyme.getTrackerManager().getTrackers();
        if (trackers.containsKey(name)) {
            Tracker tracker = trackers.get(name);
            return Response.ok(TrackerResponse.create(tracker.getName(), tracker.getVersion(), tracker.getLastSeen(), TrackerManager.decideTrackerState(tracker), tracker.getTrackingMode(), this.buildContactList(this.nzyme.getContactManager().findContactsOfTracker(tracker)), this.nzyme.getGroundStation().trackerHasPendingAnyTrackingRequest(tracker.getName()), tracker.getRssi())).build();
        }
        LOG.info("Tracker [{}] not found.", (Object)name);
        return Response.status(404).build();
    }

    private List<ContactResponse> buildContactList(List<Contact> contacts) {
        ArrayList<ContactResponse> result = Lists.newArrayList();
        for (Contact contact : contacts) {
            Optional<Bandit> opt = this.nzyme.getContactManager().findBanditByDatabaseId(contact.banditId());
            if (opt.isEmpty()) continue;
            Bandit bandit = opt.get();
            result.add(ContactResponse.create(contact.uuid(), contact.frameCount(), contact.firstSeen(), contact.lastSeen(), contact.isActive(), contact.lastSignal(), bandit.uuid().toString(), bandit.name(), contact.sourceRole().toString(), contact.sourceName(), Collections.emptyList(), Collections.emptyList()));
        }
        return result;
    }

    @POST
    @Path(value="/show/{name}/command/start_track_request")
    public Response issueStartTrackRequest(@PathParam(value="name") String trackerName, BanditTrackRequest trackRequest) {
        if (!this.nzyme.getTrackerManager().getTrackers().containsKey(trackerName)) {
            LOG.warn("Tracker not found.");
            return Response.status(404).build();
        }
        Bandit bandit = this.nzyme.getContactManager().getBandits().get(trackRequest.banditUUID());
        if (bandit == null) {
            LOG.warn("Bandit not found.");
            return Response.status(404).build();
        }
        TrackerMessage.StartTrackRequest.Builder builder = TrackerMessage.StartTrackRequest.newBuilder().setSource(this.nzyme.getNodeID()).setReceiver(trackerName).setUuid(bandit.uuid().toString());
        try {
            if (bandit.identifiers() != null) {
                for (BanditIdentifier identifier : bandit.identifiers()) {
                    TrackerMessage.ContactIdentifier.Builder idBuilder = TrackerMessage.ContactIdentifier.newBuilder().setType(identifier.getType().toString()).setUuid(identifier.getUuid().toString());
                    for (Map.Entry<String, Object> config : identifier.configuration().entrySet()) {
                        Object value = config.getValue() instanceof List ? "nzl:" + this.nzyme.getObjectMapper().writeValueAsString(config.getValue()) : (config.getValue() instanceof Map ? "nzm:" + this.nzyme.getObjectMapper().writeValueAsString(config.getValue()) : config.getValue());
                        String configRep = config.getKey() + ":\"" + value + "\"";
                        idBuilder.addConfiguration(configRep);
                    }
                    builder.addIdentifier(idBuilder.build());
                }
            }
        }
        catch (Exception e2) {
            LOG.error("Could not build bandit identifiers.", (Throwable)e2);
            return Response.status(500).build();
        }
        this.nzyme.getGroundStation().startTrackRequest(builder.build());
        return Response.accepted().build();
    }

    @POST
    @Path(value="/show/{name}/command/cancel_track_request")
    public Response issueCancelTrackRequest(@PathParam(value="name") String trackerName, BanditTrackRequest trackRequest) {
        if (!this.nzyme.getTrackerManager().getTrackers().containsKey(trackerName)) {
            return Response.status(404).build();
        }
        this.nzyme.getGroundStation().cancelTrackRequest(TrackerMessage.CancelTrackRequest.newBuilder().setSource(this.nzyme.getNodeID()).setReceiver(trackerName).build());
        return Response.accepted().build();
    }
}

