/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.rest.resources;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import horse.wtf.nzyme.NzymeLeader;
import horse.wtf.nzyme.configuration.Dot11BSSIDDefinition;
import horse.wtf.nzyme.configuration.Dot11NetworkDefinition;
import horse.wtf.nzyme.dot11.Dot11SecurityConfiguration;
import horse.wtf.nzyme.dot11.networks.BSSID;
import horse.wtf.nzyme.dot11.networks.Channel;
import horse.wtf.nzyme.dot11.networks.SSID;
import horse.wtf.nzyme.dot11.networks.beaconrate.AverageBeaconRate;
import horse.wtf.nzyme.dot11.networks.signalstrength.tracks.SignalWaterfallHistogram;
import horse.wtf.nzyme.dot11.networks.signalstrength.tracks.SignalWaterfallHistogramLoader;
import horse.wtf.nzyme.dot11.networks.signalstrength.tracks.Track;
import horse.wtf.nzyme.dot11.networks.signalstrength.tracks.TrackDetector;
import horse.wtf.nzyme.rest.authentication.Secured;
import horse.wtf.nzyme.rest.responses.networks.BSSIDResponse;
import horse.wtf.nzyme.rest.responses.networks.BSSIDsResponse;
import horse.wtf.nzyme.rest.responses.networks.ChannelResponse;
import horse.wtf.nzyme.rest.responses.networks.GlobalSSIDResponse;
import horse.wtf.nzyme.rest.responses.networks.SSIDResponse;
import horse.wtf.nzyme.rest.responses.networks.SSIDSecurityResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdbi.v3.core.statement.Query;
import org.joda.time.DateTime;

@Path(value="/api/networks")
@Produces(value={"application/json"})
@Secured
public class NetworksResource {
    private static final Logger LOG = LogManager.getLogger(NetworksResource.class);
    public static final String BEACON_RATE_AVERAGE_QUERY = "SELECT date_trunc('minute', created_at) AS bucket, AVG(beacon_rate) AS avg_beacon_rate FROM beacon_rate_history WHERE bssid = ? AND ssid = ? AND created_at > (current_timestamp at time zone 'UTC' - interval '1 day') GROUP BY bucket ORDER BY bucket ASC";
    @Inject
    private NzymeLeader nzyme;

    @GET
    @Path(value="/bssids")
    public Response bssids() {
        ArrayList<BSSIDResponse> bssids = Lists.newArrayList();
        for (BSSID bssid : this.nzyme.getNetworks().getBSSIDs().values()) {
            ArrayList<String> ssids = Lists.newArrayList();
            ArrayList<String> securityMechanisms = Lists.newArrayList();
            ArrayList<String> fingerprints = Lists.newArrayList();
            for (SSID ssid : bssid.ssids().values()) {
                ssids.add(ssid.nameSafe());
                for (Dot11SecurityConfiguration sec : ssid.getSecurity()) {
                    if (securityMechanisms.contains(sec.wpaMode().toString())) continue;
                    securityMechanisms.add(sec.wpaMode().toString());
                }
                for (Channel channel : ssid.channels().values()) {
                    for (String fingerprint : channel.fingerprints()) {
                        if (fingerprints.contains(fingerprint)) continue;
                        fingerprints.add(fingerprint);
                    }
                }
            }
            bssids.add(BSSIDResponse.create(bssid.bssid(), bssid.averageRecentSignalStrength(), ssids, bssid.oui(), securityMechanisms, fingerprints.size(), bssid.isWPS(), bssid.getLastSeen()));
        }
        return Response.ok(BSSIDsResponse.create(bssids.size(), bssids)).build();
    }

    @GET
    @Path(value="/ssids/{ssid}")
    public Response ssid(@PathParam(value="ssid") @NotNull String ssidS) {
        String ssidNameSafe = "";
        boolean ssidNameHumanReadable = false;
        ArrayList<SSIDSecurityResponse> security = Lists.newArrayList();
        long totalFrames = 0L;
        ArrayList<String> bssids = Lists.newArrayList();
        HashMap<String, List<AverageBeaconRate>> beaconRates = Maps.newHashMap();
        Integer beaconRateThreshold = this.findBeaconRateThresholdOfNetwork(ssidS).orElse(null);
        boolean anyNotMonitored = false;
        boolean found = false;
        for (BSSID bssid : this.nzyme.getNetworks().getBSSIDs().values()) {
            for (SSID ssid : bssid.ssids().values()) {
                if (!ssid.name().equals(ssidS)) continue;
                bssids.add(bssid.bssid());
                found = true;
                ssidNameSafe = ssid.nameSafe();
                ssidNameHumanReadable = ssid.isHumanReadable();
                beaconRates.put(bssid.bssid(), this.buildBeaconRateHistory(bssid, ssid, false));
                if (this.findNetworkDefinition(bssid, ssid).isEmpty()) {
                    anyNotMonitored = true;
                }
                ArrayList<String> crypto = Lists.newArrayList();
                for (Dot11SecurityConfiguration sec : ssid.getSecurity()) {
                    crypto.add(sec.asString());
                }
                for (Channel channel : ssid.channels().values()) {
                    totalFrames += channel.totalFrames().get();
                }
                for (Dot11SecurityConfiguration sec : ssid.getSecurity()) {
                    SSIDSecurityResponse x2 = SSIDSecurityResponse.create(sec.wpaMode(), sec.keyManagementModes(), sec.encryptionModes(), sec.asString());
                    if (security.contains(x2)) continue;
                    security.add(x2);
                }
            }
        }
        if (!found) {
            return Response.status(404).build();
        }
        return Response.ok(GlobalSSIDResponse.create(ssidNameHumanReadable, ssidNameSafe, !anyNotMonitored, security, totalFrames, bssids, beaconRates, beaconRateThreshold)).build();
    }

    @GET
    @Path(value="/bssids/{bssid}/ssids/{ssid}")
    public Response ssidOfBssid(@PathParam(value="bssid") @NotNull String bssid, @PathParam(value="ssid") @NotNull String ssid, @QueryParam(value="include_history") @DefaultValue(value="false") boolean includeHistory, @QueryParam(value="history_seconds") @DefaultValue(value="10800") int historySeconds) {
        bssid = bssid.toLowerCase();
        if (this.nzyme.getNetworks().getBSSIDs().containsKey(bssid)) {
            BSSID b2 = Maps.newHashMap(this.nzyme.getNetworks().getBSSIDs()).get(bssid);
            if (b2.ssids().containsKey(ssid)) {
                SSID s2 = b2.ssids().get(ssid);
                ArrayList<SSIDSecurityResponse> security = Lists.newArrayList();
                for (Dot11SecurityConfiguration sec : s2.getSecurity()) {
                    security.add(SSIDSecurityResponse.create(sec.wpaMode(), sec.keyManagementModes(), sec.encryptionModes(), sec.asString()));
                }
                SignalWaterfallHistogramLoader signalWaterfallHistogramLoader = new SignalWaterfallHistogramLoader(this.nzyme);
                TreeMap<Integer, ChannelResponse> channels = Maps.newTreeMap();
                for (Channel c2 : s2.channels().values()) {
                    ArrayList<Track> tracks;
                    SignalWaterfallHistogram histogram;
                    if (includeHistory) {
                        histogram = signalWaterfallHistogramLoader.load(b2, s2, c2, historySeconds);
                        tracks = Lists.newArrayList();
                        Dot11BSSIDDefinition config = this.nzyme.getConfiguration().findBSSIDDefinition(b2.bssid(), s2.name());
                        tracks.addAll(new TrackDetector(histogram).detect(config == null || config.trackDetectorConfig() == null ? TrackDetector.DEFAULT_CONFIG : config.trackDetectorConfig()));
                    } else {
                        histogram = null;
                        tracks = null;
                    }
                    channels.put(c2.channelNumber(), ChannelResponse.create(c2.channelNumber(), b2.bssid(), s2.nameSafe(), c2.totalFrames().get(), c2.getTotalFramesRecent().get(), c2.fingerprints(), c2.signalStrengthTable().getSignalDistributionHistogram(), 5, histogram, tracks));
                }
                ArrayList<String> fingerprints = Lists.newArrayList();
                for (Channel channel : s2.channels().values()) {
                    for (String fingerprint : channel.fingerprints()) {
                        if (fingerprints.contains(fingerprint)) continue;
                        fingerprints.add(fingerprint);
                    }
                }
                return Response.ok(SSIDResponse.create(security, b2.bssid(), s2.isHumanReadable(), s2.nameSafe(), channels, fingerprints, s2.beaconRate(), includeHistory ? this.buildBeaconRateHistory(b2, s2, true) : null, this.findBeaconRateThresholdOfNetwork(b2, s2).orElse(null), this.findNetworkDefinition(b2, s2).isPresent(), this.findMostActiveChannel(s2))).build();
            }
            LOG.debug("Could not find requested SSID [{}] on BSSID [{}].", (Object)ssid, (Object)bssid);
            return Response.status(Response.Status.NOT_FOUND).build();
        }
        LOG.debug("Could not find requested BSSID [{}].", (Object)bssid);
        return Response.status(Response.Status.NOT_FOUND).build();
    }

    @POST
    @Path(value="/reset")
    public Response reset() {
        this.nzyme.getNetworks().reset();
        return Response.ok().build();
    }

    private AverageBeaconRate createEmptyAverageBeaconRate(DateTime at2) {
        return AverageBeaconRate.create(Float.valueOf(0.0f), at2);
    }

    private List<AverageBeaconRate> buildBeaconRateHistory(BSSID b2, SSID s2, boolean gap) {
        List beaconRateHistory = this.nzyme.getDatabase().withHandle(handle -> ((Query)((Query)handle.createQuery(BEACON_RATE_AVERAGE_QUERY).bind(0, b2.bssid())).bind(1, s2.name())).mapTo(AverageBeaconRate.class).list());
        return this.buildBeaconRateHistory(beaconRateHistory, gap);
    }

    private List<AverageBeaconRate> buildBeaconRateHistory(List<AverageBeaconRate> beaconRateHistory, boolean gap) {
        DateTime yesterday = DateTime.now().minusDays(1);
        if (gap) {
            if (!beaconRateHistory.isEmpty()) {
                beaconRateHistory.set(0, this.createEmptyAverageBeaconRate(yesterday));
            } else {
                beaconRateHistory.add(this.createEmptyAverageBeaconRate(yesterday));
            }
            beaconRateHistory.add(this.createEmptyAverageBeaconRate(DateTime.now()));
        }
        return beaconRateHistory;
    }

    private Optional<Dot11NetworkDefinition> findNetworkDefinition(BSSID b2, SSID s2) {
        for (Dot11NetworkDefinition dot11Network : this.nzyme.getConfiguration().dot11Networks()) {
            if (!dot11Network.allBSSIDAddresses().contains(b2.bssid()) || !dot11Network.ssid().equals(s2.name())) continue;
            return Optional.of(dot11Network);
        }
        return Optional.empty();
    }

    private Optional<Integer> findBeaconRateThresholdOfNetwork(BSSID b2, SSID s2) {
        return this.findNetworkDefinition(b2, s2).map(Dot11NetworkDefinition::beaconRate);
    }

    private Optional<Integer> findBeaconRateThresholdOfNetwork(String ssid) {
        for (Dot11NetworkDefinition dot11Network : this.nzyme.getConfiguration().dot11Networks()) {
            if (!dot11Network.ssid().equals(ssid)) continue;
            return Optional.of(dot11Network.beaconRate());
        }
        return Optional.empty();
    }

    private Integer findMostActiveChannel(SSID ssid) {
        long highestFrameCount = 0L;
        int mostActiveChannel = 0;
        for (Channel channel : Lists.newArrayList(ssid.channels().values())) {
            if (channel.getTotalFramesRecent().get() <= highestFrameCount) continue;
            highestFrameCount = channel.getTotalFramesRecent().get();
            mostActiveChannel = channel.channelNumber();
        }
        return mostActiveChannel;
    }
}

