/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.rest.resources;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import horse.wtf.nzyme.NzymeLeader;
import horse.wtf.nzyme.alerts.Alert;
import horse.wtf.nzyme.rest.authentication.Secured;
import horse.wtf.nzyme.rest.responses.alerts.AlertConfigurationResponse;
import horse.wtf.nzyme.rest.responses.alerts.AlertDetailsResponse;
import horse.wtf.nzyme.rest.responses.alerts.AlertsListResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Path(value="/api/alerts")
@Secured
@Produces(value={"application/json"})
public class AlertsResource {
    private static final Logger LOG = LogManager.getLogger(AlertsResource.class);
    private static final int PAGE_SIZE = 25;
    @Inject
    private NzymeLeader nzyme;

    @GET
    @Path(value="/configuration")
    public Response configured() {
        ImmutableList.Builder enabled = new ImmutableList.Builder();
        ImmutableList.Builder disabled = new ImmutableList.Builder();
        for (Alert.TYPE_WIDE type : Alert.TYPE_WIDE.values()) {
            if (Alert.HIDDEN_IN_UI.contains((Object)type)) continue;
            if (this.nzyme.getConfiguration().dot11Alerts().contains((Object)type)) {
                enabled.add((Object)type);
                continue;
            }
            disabled.add((Object)type);
        }
        return Response.ok(AlertConfigurationResponse.create((List<Alert.TYPE_WIDE>)((Object)enabled.build()), (List<Alert.TYPE_WIDE>)((Object)disabled.build()))).build();
    }

    @GET
    public Response all(@QueryParam(value="page") int page) {
        if (page < 0) {
            LOG.info("Invalid page parameter. Must be larger than 0.");
            return Response.status(Response.Status.BAD_REQUEST).build();
        }
        long total = this.nzyme.getAlertsService().countAllAlerts();
        Map<UUID, Alert> alerts = this.nzyme.getAlertsService().findAllAlerts(25, 25 * page);
        ArrayList<AlertDetailsResponse> result = Lists.newArrayList();
        for (Alert alert : alerts.values()) {
            result.add(AlertDetailsResponse.fromAlert(alert));
        }
        return Response.ok(AlertsListResponse.create(total, result)).build();
    }

    @GET
    @Path(value="/active")
    public Response active(@QueryParam(value="limit") int limit) {
        if (limit == 0) {
            limit = 25;
        }
        Map<UUID, Alert> alerts = this.nzyme.getAlertsService().findActiveAlerts();
        ArrayList<AlertDetailsResponse> details = Lists.newArrayList();
        int i2 = 0;
        for (Map.Entry<UUID, Alert> entry : alerts.entrySet()) {
            if (i2 == limit) break;
            ++i2;
            Alert alert = entry.getValue();
            alert.setUUID(entry.getKey());
            details.add(AlertDetailsResponse.fromAlert(alert));
        }
        return Response.ok(AlertsListResponse.create(alerts.size(), details)).build();
    }

    @GET
    @Path(value="/show/{id}")
    public Response get(@PathParam(value="id") String id2) {
        UUID uuid;
        if (Strings.isNullOrEmpty(id2)) {
            LOG.warn("Alert ID was null or empty.");
            return Response.status(401).build();
        }
        try {
            uuid = UUID.fromString(id2);
        }
        catch (IllegalArgumentException e2) {
            LOG.warn("Invalid UUID [{}].", (Object)id2, (Object)e2);
            return Response.status(401).build();
        }
        try {
            Alert alert = this.nzyme.getAlertsService().findAlert(uuid);
            if (alert != null) {
                return Response.ok(AlertDetailsResponse.fromAlert(alert)).build();
            }
            return Response.status(404).build();
        }
        catch (Exception e3) {
            return Response.status(500).build();
        }
    }
}

