/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.reporting.reports;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import freemarker.template.Template;
import horse.wtf.nzyme.NzymeLeader;
import horse.wtf.nzyme.configuration.Dot11BSSIDDefinition;
import horse.wtf.nzyme.configuration.Dot11NetworkDefinition;
import horse.wtf.nzyme.reporting.ReportBase;
import horse.wtf.nzyme.reporting.ReportJob;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.quartz.Job;
import org.quartz.JobExecutionException;

public class WirelessInventoryReport
extends ReportBase {
    public static final String NAME = "Wireless Inventory";

    public WirelessInventoryReport(int hourOfDay, int minuteOfHour) {
        super(hourOfDay, minuteOfHour);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Class<? extends Job> getJobClass() {
        return Report.class;
    }

    public static final class Report
    extends ReportJob {
        @Override
        public String runReport(NzymeLeader nzyme, List<String> emailReceivers) throws JobExecutionException {
            try {
                HashMap<String, Object> parameters = Maps.newHashMap();
                parameters.put("title", "nzyme - Wireless Inventory");
                parameters.put("time_range", "Previous 24 hours");
                parameters.put("generated_at", DateTime.now().toString(LONG_DATETIME));
                parameters.put("ssids", this.buildAssetList(nzyme.getConfiguration().dot11Networks()));
                parameters.put("enabled_alerts", nzyme.getConfiguration().dot11Alerts());
                Template template = this.getTemplateConfig().getTemplate("reports/wireless_inventory_report.ftl");
                StringWriter writer = new StringWriter();
                template.process(parameters, writer);
                return writer.toString();
            }
            catch (Exception e2) {
                throw new JobExecutionException("Could not create report content.", e2);
            }
        }

        private Map<String, Object> buildAssetList(List<Dot11NetworkDefinition> networks) {
            HashMap<String, Object> result = Maps.newHashMap();
            for (Dot11NetworkDefinition network : networks) {
                ArrayList bssids = Lists.newArrayList();
                for (Dot11BSSIDDefinition bssid : network.bssids()) {
                    HashMap<String, String> params = Maps.newHashMap();
                    params.put("bssid", bssid.address());
                    params.put("fingerprints", Joiner.on(",").join(bssid.fingerprints()));
                    bssids.add(params);
                }
                HashMap<String, Object> ssid = Maps.newHashMap();
                ssid.put("security", Joiner.on(",").join(network.security()));
                ssid.put("channels", Joiner.on(",").join(network.channels()));
                ssid.put("bssids", bssids);
                result.put(network.ssid(), ssid);
            }
            return result;
        }

        @Override
        public String getName() {
            return WirelessInventoryReport.NAME;
        }
    }
}

