/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.reporting.reports;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import freemarker.template.Template;
import horse.wtf.nzyme.NzymeLeader;
import horse.wtf.nzyme.alerts.Alert;
import horse.wtf.nzyme.dot11.networks.sentry.db.SentrySSID;
import horse.wtf.nzyme.events.Event;
import horse.wtf.nzyme.reporting.ReportBase;
import horse.wtf.nzyme.reporting.ReportJob;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.quartz.Job;
import org.quartz.JobExecutionException;

public class TacticalSummaryReport
extends ReportBase {
    private static final Logger LOG = LogManager.getLogger(TacticalSummaryReport.class);
    public static final String NAME = "Tactical Summary";

    public TacticalSummaryReport(int hourOfDay, int minuteOfHour) {
        super(hourOfDay, minuteOfHour);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Class<? extends Job> getJobClass() {
        return Report.class;
    }

    public static final class Report
    extends ReportJob {
        @Override
        public String runReport(NzymeLeader nzyme, List<String> emailReceivers) throws JobExecutionException {
            try {
                List<Map<String, String>> alerts = this.buildAlerts(nzyme);
                HashMap<String, Object> parameters = Maps.newHashMap();
                parameters.put("title", "nzyme - Tactical Summary");
                parameters.put("time_range", "Previous 24 hours");
                parameters.put("generated_at", DateTime.now().toString(LONG_DATETIME));
                parameters.put("networks", this.buildNetworks(nzyme));
                parameters.put("alerts", alerts);
                parameters.put("alerts_count", alerts.size());
                parameters.put("system_restarts", nzyme.getEventService().countAllOfTypeOfLast24Hours(Event.TYPE.STARTUP));
                parameters.put("probe_malfunctions", nzyme.getEventService().countAllOfTypeOfLast24Hours(Event.TYPE.BROKEN_PROBE));
                Template template = this.getTemplateConfig().getTemplate("reports/tactical_summary_report.ftl");
                StringWriter writer = new StringWriter();
                template.process(parameters, writer);
                return writer.toString();
            }
            catch (Exception e2) {
                throw new JobExecutionException("Could not create report content.", e2);
            }
        }

        @Override
        public String getName() {
            return TacticalSummaryReport.NAME;
        }

        private List<Map<String, String>> buildAlerts(NzymeLeader nzyme) {
            ArrayList<Map<String, String>> result = Lists.newArrayList();
            for (Alert alert : nzyme.getAlertsService().findAllAlertsSince24HoursAgo(100).values()) {
                HashMap<String, String> alertData = Maps.newHashMap();
                alertData.put("type", alert.getType().toString());
                alertData.put("first_seen", alert.getFirstSeen().withZone(DateTimeZone.getDefault()).toString(LONG_DATETIME_LESS_ZONE));
                alertData.put("last_seen", alert.getLastSeen().withZone(DateTimeZone.getDefault()).toString(LONG_DATETIME_LESS_ZONE));
                alertData.put("frames", alert.isUseFrameCount() ? alert.getFrameCount().toString() : "n/a");
                result.add(alertData);
            }
            return result;
        }

        private List<Map<String, Object>> buildNetworks(NzymeLeader nzyme) {
            ArrayList<Map<String, Object>> result = Lists.newArrayList();
            ImmutableList.Builder ssids = new ImmutableList.Builder();
            for (SentrySSID newSSID : nzyme.getSentry().findNewToday()) {
                if (Strings.isNullOrEmpty(newSSID.ssid())) continue;
                ssids.add(newSSID.ssid());
            }
            ImmutableCollection newNetworks = ssids.build();
            List sorted2 = nzyme.getSentry().findSeenToday().stream().sorted(Comparator.comparing(SentrySSID::ssid, Comparator.nullsFirst(Comparator.naturalOrder()))).collect(Collectors.toList());
            for (SentrySSID network : sorted2) {
                if (Strings.isNullOrEmpty(network.ssid())) continue;
                HashMap<String, Object> ssidData = Maps.newHashMap();
                ssidData.put("ssid", network.ssid());
                ssidData.put("first_seen", network.firstSeen().toString(LONG_DATETIME_LESS_ZONE));
                ssidData.put("last_seen", network.lastSeen().toString(LONG_DATETIME_LESS_ZONE));
                ssidData.put("new_today", ((ImmutableList)newNetworks).contains(network.ssid()));
                result.add(ssidData);
            }
            return result;
        }
    }
}

