/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.remote.inputs;

import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import com.google.protobuf.InvalidProtocolBufferException;
import horse.wtf.nzyme.NzymeLeader;
import horse.wtf.nzyme.dot11.MalformedFrameException;
import horse.wtf.nzyme.dot11.frames.Dot11FrameFactory;
import horse.wtf.nzyme.processing.FrameProcessor;
import horse.wtf.nzyme.remote.protobuf.NzymeMessage;
import horse.wtf.nzyme.util.MetricNames;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.pcap4j.packet.IllegalRawDataException;

public class RemoteFrameInput {
    private static final Logger LOG = LogManager.getLogger(RemoteFrameInput.class);
    private final FrameProcessor processor;
    private final Dot11FrameFactory frameFactory;
    private final InetSocketAddress address;
    private final Meter remoteFramesReceived;
    private final Timer remoteFrameTimer;
    private final AtomicBoolean inLoop = new AtomicBoolean(false);
    private DatagramSocket socket;

    public RemoteFrameInput(NzymeLeader nzyme, InetSocketAddress address) {
        this.address = address;
        this.processor = nzyme.getFrameProcessor();
        this.frameFactory = new Dot11FrameFactory(nzyme.getMetrics(), nzyme.getAnonymizer());
        this.remoteFramesReceived = nzyme.getMetrics().meter(MetricNames.REMOTE_FRAMES_RECEIVED);
        this.remoteFrameTimer = nzyme.getMetrics().timer(MetricNames.REMOTE_FRAMES_TIMING);
    }

    private void initialize() throws SocketException {
        if (this.socket != null && this.socket.isBound()) {
            this.socket.close();
        }
        this.socket = new DatagramSocket(this.address);
    }

    public Runnable run() {
        return () -> {
            LOG.info("Starting remote frame input at [{}].", (Object)this.address);
            while (true) {
                block10: {
                    try {
                        if (this.inLoop.get()) break block10;
                        this.initialize();
                    }
                    catch (Exception e2) {
                        this.inLoop.set(false);
                        LOG.error("Could not initialize remote input at [{}]. Retrying soon.", (Object)this.address, (Object)e2);
                        try {
                            Thread.sleep(2500L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                }
                this.inLoop.set(true);
                try {
                    byte[] buffer = new byte[4096];
                    DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
                    this.socket.receive(packet);
                    Timer.Context time = this.remoteFrameTimer.time();
                    byte[] payload = Arrays.copyOfRange(packet.getData(), 0, packet.getLength());
                    NzymeMessage.Message message = NzymeMessage.Message.parseFrom(payload);
                    if (!message.getMessageType().equals("frame")) {
                        LOG.trace("Ignoring frame type [{}].", (Object)message.getMessageType());
                        continue;
                    }
                    if (!message.getFrame().getFrameType().equals("802.11")) {
                        LOG.trace("Ignoring frame type [{}].", (Object)message.getFrame().getFrameType());
                        continue;
                    }
                    this.remoteFramesReceived.mark();
                    NzymeMessage.Dot11Frame frame = message.getFrame().getDot11Frame();
                    this.processor.processDot11Frame(this.frameFactory.fromRemote(frame));
                    time.stop();
                    continue;
                }
                catch (InvalidProtocolBufferException | MalformedFrameException | IllegalRawDataException e3) {
                    LOG.warn("Invalid content of received remote frame. Skipping but not resetting connection.", e3);
                    continue;
                }
                catch (Exception e4) {
                    LOG.warn("Error receiving remote frame. Skipping.", (Throwable)e4);
                    this.inLoop.set(false);
                    continue;
                }
                break;
            }
        };
    }
}

