/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.remote.forwarders;

import com.typesafe.config.Config;
import horse.wtf.nzyme.configuration.ForwarderDefinition;
import horse.wtf.nzyme.remote.forwarders.Forwarder;
import horse.wtf.nzyme.remote.forwarders.UDPForwarder;
import java.net.InetSocketAddress;

public class ForwarderFactory {
    private final String nzymeId;

    public ForwarderFactory(String nzymeId) {
        this.nzymeId = nzymeId;
    }

    public Forwarder fromConfigurationDefinition(ForwarderDefinition definition) {
        String def;
        switch (def = definition.type().toLowerCase()) {
            case "udp": {
                return new UDPForwarder(this.parseInetSocketAddress(definition.configuration()), this.nzymeId);
            }
        }
        throw new RuntimeException("Unknown forwarder type [" + def + "].");
    }

    private InetSocketAddress parseInetSocketAddress(Config config) {
        if (config.hasPath("host") && config.hasPath("port")) {
            return new InetSocketAddress(config.getString("host"), config.getInt("port"));
        }
        throw new RuntimeException("Invalid configuration. Expecting \"host\" and \"port\" set in forwarder configuration. Please consult the forwarder documentation.");
    }
}

