/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.periodicals.alerting.beaconrate;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import horse.wtf.nzyme.NzymeLeader;
import horse.wtf.nzyme.alerts.BeaconRateAnomalyAlert;
import horse.wtf.nzyme.alerts.service.AlertsService;
import horse.wtf.nzyme.configuration.Dot11NetworkDefinition;
import horse.wtf.nzyme.configuration.leader.LeaderConfiguration;
import horse.wtf.nzyme.dot11.networks.BSSID;
import horse.wtf.nzyme.dot11.networks.Networks;
import horse.wtf.nzyme.dot11.networks.SSID;
import horse.wtf.nzyme.dot11.networks.beaconrate.BeaconRate;
import horse.wtf.nzyme.periodicals.Periodical;
import horse.wtf.nzyme.util.MetricNames;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;

public class BeaconRateAnomalyAlertMonitor
extends Periodical {
    private static final Logger LOG = LogManager.getLogger(BeaconRateAnomalyAlertMonitor.class);
    private final Networks networks;
    private final LeaderConfiguration configuration;
    private final AlertsService alertsService;
    private final Timer timer;

    public BeaconRateAnomalyAlertMonitor(NzymeLeader nzyme) {
        this.networks = nzyme.getNetworks();
        this.configuration = nzyme.getConfiguration();
        this.alertsService = nzyme.getAlertsService();
        this.timer = nzyme.getMetrics().timer(MetricRegistry.name(MetricNames.BEACON_RATE_MONITOR_TIMING, new String[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execute() {
        Timer.Context ctx = this.timer.time();
        try {
            for (BSSID bssid : this.networks.getBSSIDs().values()) {
                for (SSID ssid : bssid.ssids().values()) {
                    BeaconRate beaconRate;
                    Dot11NetworkDefinition network;
                    if (!ssid.isHumanReadable() || !this.configuration.ourSSIDs().contains(ssid.name()) || (network = this.configuration.findNetworkDefinition(bssid.bssid(), ssid.name())) == null || (beaconRate = ssid.beaconRate()) == null || beaconRate.rate() == null || !(beaconRate.rate().floatValue() > (float)network.beaconRate())) continue;
                    this.alertsService.handle(BeaconRateAnomalyAlert.create(DateTime.now(), ssid.name(), bssid.bssid(), beaconRate.rate().floatValue(), network.beaconRate()));
                }
            }
        }
        catch (Exception e2) {
            LOG.error("Beacon Rate Monitor run failed", (Throwable)e2);
        }
        finally {
            ctx.stop();
        }
    }

    @Override
    public String getName() {
        return "BeaconRateAnomalyAlertMonitor";
    }
}

