/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.periodicals;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import horse.wtf.nzyme.periodicals.Periodical;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PeriodicalManager {
    private static final Logger LOG = LogManager.getLogger(PeriodicalManager.class);
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(5, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("periodicals-%d").setUncaughtExceptionHandler((thread2, throwable) -> LOG.error("Uncaught exception in a periodical!", throwable)).build());

    public void scheduleAtFixedRate(Periodical periodical, long initialDelay, long period, TimeUnit timeUnit) {
        LOG.info("Scheduling [{}] for every <{} {}> with <{} {}> initial delay.", (Object)periodical.getName(), (Object)period, (Object)timeUnit, (Object)initialDelay, (Object)timeUnit);
        this.executor.scheduleAtFixedRate(periodical, initialDelay, period, timeUnit);
    }
}

