/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.dot11.networks.sentry;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import horse.wtf.nzyme.NzymeLeader;
import horse.wtf.nzyme.dot11.networks.sentry.db.SentrySSID;
import horse.wtf.nzyme.util.Tools;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.joda.time.DateTime;

public class Sentry {
    private static final Logger LOG = LogManager.getLogger(Sentry.class);
    private final NzymeLeader nzyme;
    private final ScheduledExecutorService executor;
    private final ConcurrentMap<String, SentrySSID> table;

    public Sentry(NzymeLeader nzyme, int syncInterval) {
        this.nzyme = nzyme;
        this.table = new ConcurrentHashMap<String, SentrySSID>();
        this.loadTable();
        this.executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("sentry-scanner").build());
        this.executor.scheduleAtFixedRate(this::syncDatabase, syncInterval, syncInterval, TimeUnit.SECONDS);
    }

    private void loadTable() {
        List entries = this.nzyme.getDatabase().withHandle(handle -> handle.createQuery("SELECT * FROM sentry_ssids").mapTo(SentrySSID.class).list());
        LOG.info("Loading <{}> SSIDs from database into sentry table.", (Object)entries.size());
        for (SentrySSID entry : entries) {
            this.table.put(entry.ssid(), entry);
        }
    }

    private void syncDatabase() {
        for (SentrySSID entry : this.table.values()) {
            try {
                long count = this.nzyme.getDatabase().withHandle(handle -> ((Query)handle.createQuery("SELECT COUNT(*) FROM sentry_ssids WHERE ssid = :ssid").bind("ssid", entry.ssid())).mapTo(Long.class).first());
                if (count == 0L) {
                    this.nzyme.getDatabase().useHandle(handle -> ((Update)((Update)((Update)handle.createUpdate("INSERT INTO sentry_ssids(ssid, first_seen, last_seen) VALUES(:ssid, :first_seen, :last_seen)").bind("ssid", entry.ssid())).bind("first_seen", (Object)entry.firstSeen().withMillisOfSecond(0))).bind("last_seen", (Object)entry.lastSeen().withMillisOfSecond(0))).execute());
                    continue;
                }
                this.nzyme.getDatabase().useHandle(handle -> ((Update)((Update)handle.createUpdate("UPDATE sentry_ssids SET last_seen = :last_seen WHERE ssid = :ssid").bind("last_seen", (Object)entry.lastSeen().withMillisOfSecond(0))).bind("ssid", entry.ssid())).execute());
            }
            catch (Exception e2) {
                LOG.error("Could not sync sentry SSID. Skipping.", (Throwable)e2);
            }
        }
    }

    public void tickSSID(String ssid, DateTime date) {
        if (ssid == null || ssid.trim().isEmpty() || !Tools.isHumanlyReadable(ssid)) {
            throw new RuntimeException("Cannot use NULL, empty or non-humanly-readable SSID in Sentry.");
        }
        if (this.table.containsKey(ssid)) {
            SentrySSID entry = (SentrySSID)this.table.get(ssid);
            this.table.put(ssid, SentrySSID.create(ssid, entry.firstSeen(), date));
        } else {
            this.table.put(ssid, SentrySSID.create(ssid, date, date));
        }
    }

    public ImmutableList<SentrySSID> getSSIDs() {
        return ImmutableList.copyOf(this.table.values());
    }

    public ImmutableList<SentrySSID> findSeenToday() {
        ImmutableList.Builder result = new ImmutableList.Builder();
        for (SentrySSID ssid : this.getSSIDs()) {
            if (!ssid.lastSeen().isAfter(DateTime.now().minusHours(24))) continue;
            result.add(ssid);
        }
        return result.build();
    }

    public ImmutableList<SentrySSID> findNewToday() {
        ImmutableList.Builder result = new ImmutableList.Builder();
        for (SentrySSID ssid : this.findSeenToday()) {
            if (!ssid.firstSeen().isAfter(DateTime.now().minusHours(24))) continue;
            result.add(ssid);
        }
        return result.build();
    }

    public boolean knowsSSID(String ssid) {
        if (ssid == null || ssid.trim().isEmpty() || !Tools.isHumanlyReadable(ssid)) {
            throw new RuntimeException("Cannot use NULL, empty or non-humanly-readable SSID in Sentry.");
        }
        return this.table.containsKey(ssid);
    }

    public void stop() {
        this.executor.shutdown();
    }
}

