/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.dot11.networks.beaconrate;

import horse.wtf.nzyme.NzymeLeader;
import horse.wtf.nzyme.database.Database;
import horse.wtf.nzyme.dot11.networks.beaconrate.BeaconRate;
import horse.wtf.nzyme.systemstatus.SystemStatus;
import horse.wtf.nzyme.util.Tools;
import org.jdbi.v3.core.statement.Query;

public class BeaconRateManager {
    private static final String AVERAGE_QUERY = "SELECT AVG(beacon_rate) FROM beacon_rate_history WHERE bssid = ? AND ssid = ? AND created_at > (current_timestamp at time zone 'UTC' - interval '1 minute')";
    private final Database database;
    private final SystemStatus systemStatus;

    public BeaconRateManager(NzymeLeader nzyme) {
        this.database = nzyme.getDatabase();
        this.systemStatus = nzyme.getSystemStatus();
    }

    public BeaconRate getAverageBeaconRate(String bssid, String ssid) {
        if (!Tools.isHumanlyReadable(ssid)) {
            return BeaconRate.create(Float.valueOf(0.0f), this.systemStatus.isInStatus(SystemStatus.TYPE.TRAINING));
        }
        Float avg = this.database.withHandle(handle -> ((Query)((Query)handle.createQuery(AVERAGE_QUERY).bind(0, bssid)).bind(1, ssid)).mapTo(Float.class).first());
        if (avg == null) {
            avg = Float.valueOf(0.0f);
        }
        return BeaconRate.create(avg, this.systemStatus.isInStatus(SystemStatus.TYPE.TRAINING));
    }
}

