/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.dot11.networks;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import horse.wtf.nzyme.dot11.Dot11SecurityConfiguration;
import horse.wtf.nzyme.dot11.networks.AutoValue_SSID;
import horse.wtf.nzyme.dot11.networks.Channel;
import horse.wtf.nzyme.dot11.networks.beaconrate.AverageBeaconRate;
import horse.wtf.nzyme.dot11.networks.beaconrate.BeaconRate;
import horse.wtf.nzyme.dot11.networks.beaconrate.BeaconRateManager;
import horse.wtf.nzyme.util.Tools;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

@AutoValue
public abstract class SSID {
    private List<Dot11SecurityConfiguration> security = Lists.newArrayList();
    @JsonProperty(value="beacon_rate_history")
    public List<AverageBeaconRate> beaconRateHistory = Collections.emptyList();
    @JsonIgnore
    public final AtomicInteger beaconCount = new AtomicInteger(1);

    @JsonIgnore
    public abstract BeaconRateManager beaconRateManager();

    @JsonIgnore
    public abstract String name();

    @JsonProperty
    public abstract String bssid();

    @JsonProperty
    public abstract Map<Integer, Channel> channels();

    @JsonProperty(value="human_readable")
    public boolean isHumanReadable() {
        return Tools.isHumanlyReadable(this.name());
    }

    @JsonProperty
    public List<Dot11SecurityConfiguration> getSecurity() {
        return this.security;
    }

    @JsonProperty(value="name")
    public String nameSafe() {
        if (this.isHumanReadable()) {
            return this.name();
        }
        return "[not human readable]";
    }

    @JsonProperty(value="beacon_rate")
    public BeaconRate beaconRate() {
        return this.beaconRateManager().getAverageBeaconRate(this.bssid(), this.name());
    }

    @JsonIgnore
    public void setBeaconRateHistory(List<AverageBeaconRate> history) {
        this.beaconRateHistory = history;
    }

    public static SSID create(String name, String bssid, BeaconRateManager beaconRateManager) {
        return SSID.builder().name(name).bssid(bssid).channels(Maps.newHashMap()).beaconRateManager(beaconRateManager).build();
    }

    @JsonIgnore
    public void updateSecurity(List<Dot11SecurityConfiguration> security) {
        this.security = security;
    }

    public static Builder builder() {
        return new AutoValue_SSID.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder name(String var1);

        public abstract Builder bssid(String var1);

        public abstract Builder channels(Map<Integer, Channel> var1);

        public abstract Builder beaconRateManager(BeaconRateManager var1);

        public abstract SSID build();
    }
}

