/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.dot11.networks;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import horse.wtf.nzyme.NzymeLeader;
import horse.wtf.nzyme.dot11.networks.AutoValue_Channel;
import horse.wtf.nzyme.dot11.networks.signalstrength.SignalStrengthTable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

@AutoValue
public abstract class Channel {
    @JsonIgnore
    private AtomicLong previousTotalFramesRecent;

    @JsonProperty(value="channel_number")
    public abstract int channelNumber();

    @JsonProperty(value="bssid")
    public abstract String bssid();

    @JsonProperty(value="ssid")
    public abstract String ssid();

    @JsonProperty(value="total_frames")
    public abstract AtomicLong totalFrames();

    @JsonProperty(value="fingerprints")
    public abstract List<String> fingerprints();

    @JsonIgnore
    public abstract SignalStrengthTable signalStrengthTable();

    @JsonIgnore
    public void registerFingerprint(String fingerprint) {
        if (!this.fingerprints().contains(fingerprint)) {
            this.fingerprints().add(fingerprint);
        }
    }

    @JsonIgnore
    public abstract AtomicLong totalFramesRecent();

    @JsonProperty(value="total_frames_recent")
    public AtomicLong getTotalFramesRecent() {
        if (this.previousTotalFramesRecent == null) {
            return this.totalFramesRecent();
        }
        return this.previousTotalFramesRecent;
    }

    @JsonIgnore
    public void cycleRecentFrames() {
        if (this.previousTotalFramesRecent == null) {
            this.previousTotalFramesRecent = new AtomicLong(0L);
        }
        this.previousTotalFramesRecent.set(this.totalFramesRecent().get());
        this.totalFramesRecent().set(0L);
    }

    public static Channel create(NzymeLeader nzyme, int channelNumber, String bssid, String ssid, AtomicLong totalFrames, AtomicLong totalFramesRecent, final String fingerprint) {
        ArrayList<String> fingerprints = new ArrayList<String>(){
            {
                if (fingerprint != null) {
                    this.add(fingerprint);
                }
            }
        };
        return Channel.builder().signalStrengthTable(new SignalStrengthTable(bssid, ssid, channelNumber, nzyme.getMetrics())).bssid(bssid).ssid(ssid).channelNumber(channelNumber).totalFrames(totalFrames).totalFramesRecent(totalFramesRecent).fingerprints((List<String>)fingerprints).build();
    }

    public static Builder builder() {
        return new AutoValue_Channel.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder signalStrengthTable(SignalStrengthTable var1);

        public abstract Builder bssid(String var1);

        public abstract Builder ssid(String var1);

        public abstract Builder channelNumber(int var1);

        public abstract Builder totalFrames(AtomicLong var1);

        public abstract Builder totalFramesRecent(AtomicLong var1);

        public abstract Builder fingerprints(List<String> var1);

        public abstract Channel build();
    }
}

