/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.dot11.networks;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.collect.Lists;
import com.google.common.math.Stats;
import horse.wtf.nzyme.dot11.networks.AutoValue_BSSID;
import horse.wtf.nzyme.dot11.networks.Channel;
import horse.wtf.nzyme.dot11.networks.SSID;
import java.util.ArrayList;
import java.util.Map;
import org.joda.time.DateTime;

@AutoValue
public abstract class BSSID {
    private DateTime lastSeen = new DateTime();
    private boolean isWPS;

    @JsonProperty
    public abstract Map<String, SSID> ssids();

    @JsonProperty
    public abstract String oui();

    @JsonProperty
    public abstract String bssid();

    @JsonProperty(value="is_wps")
    public boolean isWPS() {
        return this.isWPS;
    }

    @JsonProperty(value="last_seen")
    public DateTime getLastSeen() {
        return this.lastSeen;
    }

    @JsonProperty(value="average_recent_signal_strength")
    public int averageRecentSignalStrength() {
        ArrayList<Integer> records = Lists.newArrayList();
        for (SSID ssid : this.ssids().values()) {
            for (Channel channel : ssid.channels().values()) {
                records.addAll(channel.signalStrengthTable().copyOfAllValues());
            }
        }
        if (records.isEmpty()) {
            return -100;
        }
        return (int)Math.round(Stats.meanOf(records));
    }

    public static BSSID create(Map<String, SSID> ssids, String oui, String bssid) {
        return BSSID.builder().ssids(ssids).oui(oui).bssid(bssid).build();
    }

    @JsonIgnore
    public void updateLastSeen() {
        this.lastSeen = new DateTime();
    }

    @JsonIgnore
    public void updateIsWPS(boolean isWPS) {
        this.isWPS = isWPS;
    }

    public static Builder builder() {
        return new AutoValue_BSSID.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder ssids(Map<String, SSID> var1);

        public abstract Builder oui(String var1);

        public abstract Builder bssid(String var1);

        public abstract BSSID build();
    }
}

