/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.dot11.interceptors;

import com.google.common.collect.ImmutableList;
import horse.wtf.nzyme.alerts.Alert;
import horse.wtf.nzyme.alerts.UnexpectedSSIDBeaconAlert;
import horse.wtf.nzyme.alerts.UnexpectedSSIDProbeRespAlert;
import horse.wtf.nzyme.alerts.service.AlertsService;
import horse.wtf.nzyme.configuration.Dot11NetworkDefinition;
import horse.wtf.nzyme.dot11.Dot11FrameInterceptor;
import horse.wtf.nzyme.dot11.frames.Dot11BeaconFrame;
import horse.wtf.nzyme.dot11.frames.Dot11ProbeResponseFrame;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;

public class UnexpectedSSIDInterceptorSet {
    private final List<Dot11NetworkDefinition> configuredNetworks;
    private final AlertsService alerts;

    public UnexpectedSSIDInterceptorSet(AlertsService alerts, List<Dot11NetworkDefinition> networks) {
        this.alerts = alerts;
        this.configuredNetworks = networks;
    }

    public List<Dot11FrameInterceptor> getInterceptors() {
        ImmutableList.Builder interceptors = new ImmutableList.Builder();
        interceptors.add(new Dot11FrameInterceptor<Dot11ProbeResponseFrame>(){

            @Override
            public void intercept(Dot11ProbeResponseFrame frame) {
                if (frame.ssid() == null) {
                    return;
                }
                for (Dot11NetworkDefinition network : UnexpectedSSIDInterceptorSet.this.configuredNetworks) {
                    if (!network.allBSSIDAddresses().contains(frame.transmitter()) || network.ssid().equals(frame.ssid())) continue;
                    UnexpectedSSIDInterceptorSet.this.alerts.handle(UnexpectedSSIDProbeRespAlert.create(DateTime.now(), frame.ssid(), frame.transmitter(), frame.meta().getChannel(), frame.meta().getFrequency(), frame.meta().getAntennaSignal(), 1L));
                }
            }

            @Override
            public byte forSubtype() {
                return 5;
            }

            @Override
            public List<Class<? extends Alert>> raisesAlerts() {
                return new ArrayList<Class<? extends Alert>>(){
                    {
                        this.add(UnexpectedSSIDProbeRespAlert.class);
                    }
                };
            }
        });
        interceptors.add(new Dot11FrameInterceptor<Dot11BeaconFrame>(){

            @Override
            public void intercept(Dot11BeaconFrame frame) {
                if (frame.ssid() == null) {
                    return;
                }
                for (Dot11NetworkDefinition network : UnexpectedSSIDInterceptorSet.this.configuredNetworks) {
                    if (!network.allBSSIDAddresses().contains(frame.transmitter()) || network.ssid().equals(frame.ssid())) continue;
                    UnexpectedSSIDInterceptorSet.this.alerts.handle(UnexpectedSSIDBeaconAlert.create(DateTime.now(), frame.ssid(), frame.transmitter(), frame.meta().getChannel(), frame.meta().getFrequency(), frame.meta().getAntennaSignal(), 1L));
                }
            }

            @Override
            public byte forSubtype() {
                return 8;
            }

            @Override
            public List<Class<? extends Alert>> raisesAlerts() {
                return new ArrayList<Class<? extends Alert>>(){
                    {
                        this.add(UnexpectedSSIDBeaconAlert.class);
                    }
                };
            }
        });
        return interceptors.build();
    }
}

