/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.dot11.interceptors;

import horse.wtf.nzyme.alerts.Alert;
import horse.wtf.nzyme.alerts.PwnagotchiAdvertisementAlert;
import horse.wtf.nzyme.alerts.service.AlertsService;
import horse.wtf.nzyme.dot11.Dot11FrameInterceptor;
import horse.wtf.nzyme.dot11.frames.Dot11BeaconFrame;
import horse.wtf.nzyme.dot11.misc.PwnagotchiAdvertisementExtractor;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;

public class PwnagotchiAdvertisementInterceptor
implements Dot11FrameInterceptor<Dot11BeaconFrame> {
    private final PwnagotchiAdvertisementExtractor extractor;
    private final AlertsService alerts;

    public PwnagotchiAdvertisementInterceptor(AlertsService alerts) {
        this.alerts = alerts;
        this.extractor = new PwnagotchiAdvertisementExtractor();
    }

    @Override
    public void intercept(Dot11BeaconFrame frame) {
        this.extractor.extract(frame).ifPresent(advertisement -> this.alerts.handle(PwnagotchiAdvertisementAlert.create(DateTime.now(), advertisement, frame.meta().getChannel(), frame.meta().getFrequency(), frame.meta().getAntennaSignal(), 1L)));
    }

    @Override
    public byte forSubtype() {
        return 8;
    }

    @Override
    public List<Class<? extends Alert>> raisesAlerts() {
        return new ArrayList<Class<? extends Alert>>(){
            {
                this.add(PwnagotchiAdvertisementAlert.class);
            }
        };
    }
}

