/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.dot11.interceptors;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import horse.wtf.nzyme.NzymeLeader;
import horse.wtf.nzyme.alerts.Alert;
import horse.wtf.nzyme.dot11.Dot11FrameInterceptor;
import horse.wtf.nzyme.dot11.Dot11MetaInformation;
import horse.wtf.nzyme.dot11.frames.Dot11AssociationRequestFrame;
import horse.wtf.nzyme.dot11.frames.Dot11AssociationResponseFrame;
import horse.wtf.nzyme.dot11.frames.Dot11AuthenticationFrame;
import horse.wtf.nzyme.dot11.frames.Dot11BeaconFrame;
import horse.wtf.nzyme.dot11.frames.Dot11DeauthenticationFrame;
import horse.wtf.nzyme.dot11.frames.Dot11DisassociationFrame;
import horse.wtf.nzyme.dot11.frames.Dot11ProbeRequestFrame;
import horse.wtf.nzyme.dot11.frames.Dot11ProbeResponseFrame;
import horse.wtf.nzyme.notifications.Notification;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BroadMonitorInterceptorSet {
    private static final Logger LOG = LogManager.getLogger(BroadMonitorInterceptorSet.class);
    private final NzymeLeader nzyme;

    public BroadMonitorInterceptorSet(NzymeLeader nzyme) {
        this.nzyme = nzyme;
    }

    public List<Dot11FrameInterceptor> getInterceptors() {
        ImmutableList.Builder interceptors = new ImmutableList.Builder();
        interceptors.add(new Dot11FrameInterceptor<Dot11DisassociationFrame>(){

            @Override
            public void intercept(Dot11DisassociationFrame frame) {
                String message = frame.transmitter() + " is disassociating from " + frame.destination() + " (" + frame.reasonString() + ")";
                BroadMonitorInterceptorSet.this.nzyme.notifyUplinks(new Notification(message, frame.meta().getChannel()).addField("transmitter", frame.transmitter()).addField("destination", frame.destination()).addField("reason_code", frame.reasonCode()).addField("reason_string", frame.reasonString()).addField("subtype", "disassoc"), frame.meta());
                BroadMonitorInterceptorSet.this.nzyme.forwardFrame(frame);
                LOG.debug(message);
            }

            @Override
            public byte forSubtype() {
                return 10;
            }

            @Override
            public List<Class<? extends Alert>> raisesAlerts() {
                return Collections.emptyList();
            }
        });
        interceptors.add(new Dot11FrameInterceptor<Dot11AssociationRequestFrame>(){

            @Override
            public void intercept(Dot11AssociationRequestFrame frame) {
                BroadMonitorInterceptorSet.this.nzyme.getClients().registerAssociationRequestFrame(frame);
                String message = frame.transmitter() + " is requesting to associate with " + frame.ssid() + " at " + frame.destination();
                BroadMonitorInterceptorSet.this.nzyme.notifyUplinks(new Notification(message, frame.meta().getChannel()).addField("transmitter", frame.transmitter()).addField("destination", frame.destination()).addField("ssid", frame.ssid() == null ? "[no SSID]" : frame.ssid()).addField("subtype", "assoc-req"), frame.meta());
                BroadMonitorInterceptorSet.this.nzyme.forwardFrame(frame);
                LOG.debug(message);
            }

            @Override
            public byte forSubtype() {
                return 0;
            }

            @Override
            public List<Class<? extends Alert>> raisesAlerts() {
                return Collections.emptyList();
            }
        });
        interceptors.add(new Dot11FrameInterceptor<Dot11AssociationResponseFrame>(){

            @Override
            public void intercept(Dot11AssociationResponseFrame frame) {
                String message = frame.transmitter() + " answered association request from " + frame.destination() + ". Response: " + frame.response().toUpperCase() + " (" + frame.responseCode() + ")";
                BroadMonitorInterceptorSet.this.nzyme.notifyUplinks(new Notification(message, frame.meta().getChannel()).addField("transmitter", frame.transmitter()).addField("destination", frame.destination()).addField("response_code", frame.responseCode()).addField("response_string", frame.response()).addField("subtype", "assoc-resp"), frame.meta());
                BroadMonitorInterceptorSet.this.nzyme.forwardFrame(frame);
                LOG.debug(message);
            }

            @Override
            public byte forSubtype() {
                return 1;
            }

            @Override
            public List<Class<? extends Alert>> raisesAlerts() {
                return Collections.emptyList();
            }
        });
        interceptors.add(new Dot11FrameInterceptor<Dot11AuthenticationFrame>(){

            @Override
            public void intercept(Dot11AuthenticationFrame frame) {
                Object message = "";
                HashMap<String, Object> additionalFields = Maps.newHashMap();
                block0 : switch (frame.algorithm()) {
                    case OPEN_SYSTEM: {
                        switch (frame.transactionSequence()) {
                            case 1: {
                                message = frame.transmitter() + " is requesting to authenticate with Open System (Open, WPA, WPA2, ...) at " + frame.destination();
                                break block0;
                            }
                            case 2: {
                                message = frame.transmitter() + " is responding to Open System (Open, WPA, WPA2, ...) authentication request from " + frame.destination() + ". (" + frame.statusString() + ")";
                                additionalFields.put("response_code", frame.statusCode());
                                additionalFields.put("response_string", frame.statusString());
                                break block0;
                            }
                        }
                        LOG.trace("Invalid Open System authentication transaction sequence number [{}]. Skipping.", (Object)frame.transactionSequence());
                        return;
                    }
                    case SAE: {
                        switch (frame.transactionSequence()) {
                            case 1: {
                                message = frame.transmitter() + " is requesting to authenticate using SAE (WPA3) at " + frame.destination();
                                break block0;
                            }
                            case 2: {
                                message = frame.transmitter() + " is responding to SAE (WPA3) authentication request from " + frame.destination() + ". (" + frame.statusString() + ")";
                                additionalFields.put("response_code", frame.statusCode());
                                additionalFields.put("response_string", frame.statusString());
                                break block0;
                            }
                        }
                        LOG.trace("Invalid SAE authentication transaction sequence number [{}]. Skipping.", (Object)frame.transactionSequence());
                        return;
                    }
                    case SHARED_KEY: {
                        switch (frame.transactionSequence()) {
                            case 1: {
                                message = frame.transmitter() + " is requesting to authenticate using WEP at " + frame.destination();
                                break block0;
                            }
                            case 2: {
                                message = frame.transmitter() + " is responding to WEP authentication request at " + frame.destination() + " with clear text challenge.";
                                break block0;
                            }
                            case 4: {
                                message = frame.transmitter() + " is responding to WEP authentication request from " + frame.destination() + ". (" + frame.statusString() + ")";
                                additionalFields.put("response_code", frame.statusCode());
                                additionalFields.put("response_string", frame.statusString());
                                break block0;
                            }
                        }
                        LOG.trace("Invalid WEP authentication transaction sequence number [{}]. Skipping.", (Object)frame.transactionSequence());
                        return;
                    }
                }
                BroadMonitorInterceptorSet.this.nzyme.notifyUplinks(new Notification((String)message, frame.meta().getChannel()).addField("transmitter", frame.transmitter()).addField("destination", frame.destination()).addField("authentication_algorithm", frame.algorithm().toString().toLowerCase()).addField("transaction_sequence_number", frame.transactionSequence()).addField("subtype", "auth").addFields(additionalFields), frame.meta());
                BroadMonitorInterceptorSet.this.nzyme.forwardFrame(frame);
                LOG.debug((String)message);
            }

            @Override
            public byte forSubtype() {
                return 11;
            }

            @Override
            public List<Class<? extends Alert>> raisesAlerts() {
                return Collections.emptyList();
            }
        });
        interceptors.add(new Dot11FrameInterceptor<Dot11BeaconFrame>(){

            @Override
            public void intercept(Dot11BeaconFrame frame) {
                BroadMonitorInterceptorSet.this.nzyme.getNetworks().registerBeaconFrame(frame);
                String message = !Strings.isNullOrEmpty(frame.ssid()) ? "Received beacon from " + frame.transmitter() + " for SSID " + frame.ssid() : "Received broadcast beacon from " + frame.transmitter();
                Dot11MetaInformation meta = frame.meta();
                BroadMonitorInterceptorSet.this.nzyme.notifyUplinks(new Notification(message, frame.meta().getChannel()).addField("transmitter", frame.transmitter()).addField("transmitter_fingerprint", frame.transmitterFingerprint()).addField("ssid", Strings.isNullOrEmpty(frame.ssid()) ? "[no SSID]" : frame.ssid()).addField("security_full", frame.taggedParameters().getFullSecurityString()).addField("is_wpa1", frame.taggedParameters().isWPA1()).addField("is_wpa2", frame.taggedParameters().isWPA2()).addField("is_wpa3", frame.taggedParameters().isWPA3()).addField("is_wps", frame.taggedParameters().isWPS()).addField("subtype", "beacon"), meta);
                BroadMonitorInterceptorSet.this.nzyme.forwardFrame(frame);
                LOG.debug(message);
            }

            @Override
            public byte forSubtype() {
                return 8;
            }

            @Override
            public List<Class<? extends Alert>> raisesAlerts() {
                return Collections.emptyList();
            }
        });
        interceptors.add(new Dot11FrameInterceptor<Dot11DeauthenticationFrame>(){

            @Override
            public void intercept(Dot11DeauthenticationFrame frame) {
                String message = "Deauth: Transmitter " + frame.transmitter() + " is deauthenticating " + frame.destination() + " from BSSID " + frame.bssid() + " (" + frame.reasonString() + ")";
                BroadMonitorInterceptorSet.this.nzyme.notifyUplinks(new Notification(message, frame.meta().getChannel()).addField("transmitter", frame.transmitter()).addField("destination", frame.destination()).addField("bssid", frame.bssid()).addField("reason_code", frame.reasonCode()).addField("reason_string", frame.reasonString()).addField("subtype", "deauth"), frame.meta());
                BroadMonitorInterceptorSet.this.nzyme.forwardFrame(frame);
                LOG.debug(message);
            }

            @Override
            public byte forSubtype() {
                return 12;
            }

            @Override
            public List<Class<? extends Alert>> raisesAlerts() {
                return Collections.emptyList();
            }
        });
        interceptors.add(new Dot11FrameInterceptor<Dot11ProbeRequestFrame>(){

            @Override
            public void intercept(Dot11ProbeRequestFrame frame) {
                BroadMonitorInterceptorSet.this.nzyme.getClients().registerProbeRequestFrame(frame);
                String message = frame.isBroadcastProbe() == false ? "Probe request: " + frame.requester() + " is looking for " + frame.ssid() : "Probe request: " + frame.requester() + " is looking for any network. (null probe request)";
                BroadMonitorInterceptorSet.this.nzyme.notifyUplinks(new Notification(message, frame.meta().getChannel()).addField("ssid", frame.ssid() == null ? "[no SSID]" : frame.ssid()).addField("transmitter", frame.requester()).addField("subtype", "probe-req"), frame.meta());
                BroadMonitorInterceptorSet.this.nzyme.forwardFrame(frame);
                LOG.debug(message);
            }

            @Override
            public byte forSubtype() {
                return 4;
            }

            @Override
            public List<Class<? extends Alert>> raisesAlerts() {
                return Collections.emptyList();
            }
        });
        interceptors.add(new Dot11FrameInterceptor<Dot11ProbeResponseFrame>(){

            @Override
            public void intercept(Dot11ProbeResponseFrame frame) {
                BroadMonitorInterceptorSet.this.nzyme.getNetworks().registerProbeResponseFrame(frame);
                String message = frame.ssid() == null ? frame.transmitter() + " responded to broadcast probe request from " + frame.destination() : frame.transmitter() + " responded to probe request from " + frame.destination() + " for " + frame.ssid();
                BroadMonitorInterceptorSet.this.nzyme.notifyUplinks(new Notification(message, frame.meta().getChannel()).addField("destination", frame.destination()).addField("transmitter", frame.transmitter()).addField("ssid", frame.ssid() == null ? "[no SSID]" : frame.ssid()).addField("security_full", frame.taggedParameters().getFullSecurityString()).addField("is_wpa1", frame.taggedParameters().isWPA1()).addField("is_wpa2", frame.taggedParameters().isWPA2()).addField("is_wpa3", frame.taggedParameters().isWPA3()).addField("is_wps", frame.taggedParameters().isWPS()).addField("subtype", "probe-resp"), frame.meta());
                BroadMonitorInterceptorSet.this.nzyme.forwardFrame(frame);
                LOG.debug(message);
            }

            @Override
            public byte forSubtype() {
                return 5;
            }

            @Override
            public List<Class<? extends Alert>> raisesAlerts() {
                return Collections.emptyList();
            }
        });
        return interceptors.build();
    }
}

