/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.dot11.interceptors;

import com.google.common.collect.ImmutableList;
import horse.wtf.nzyme.alerts.Alert;
import horse.wtf.nzyme.bandits.engine.ContactIdentifierProcess;
import horse.wtf.nzyme.dot11.Dot11FrameInterceptor;
import horse.wtf.nzyme.dot11.frames.Dot11BeaconFrame;
import horse.wtf.nzyme.dot11.frames.Dot11DeauthenticationFrame;
import horse.wtf.nzyme.dot11.frames.Dot11ProbeResponseFrame;
import java.util.Collections;
import java.util.List;

public class BanditIdentifierInterceptorSet {
    private ContactIdentifierProcess ci;

    public BanditIdentifierInterceptorSet(ContactIdentifierProcess ci2) {
        this.ci = ci2;
    }

    public List<Dot11FrameInterceptor> getInterceptors() {
        ImmutableList.Builder interceptors = new ImmutableList.Builder();
        interceptors.add(new Dot11FrameInterceptor<Dot11BeaconFrame>(){

            @Override
            public void intercept(Dot11BeaconFrame frame) {
                BanditIdentifierInterceptorSet.this.ci.identify(frame);
            }

            @Override
            public byte forSubtype() {
                return 8;
            }

            @Override
            public List<Class<? extends Alert>> raisesAlerts() {
                return Collections.emptyList();
            }
        });
        interceptors.add(new Dot11FrameInterceptor<Dot11ProbeResponseFrame>(){

            @Override
            public void intercept(Dot11ProbeResponseFrame frame) {
                BanditIdentifierInterceptorSet.this.ci.identify(frame);
            }

            @Override
            public byte forSubtype() {
                return 5;
            }

            @Override
            public List<Class<? extends Alert>> raisesAlerts() {
                return Collections.emptyList();
            }
        });
        interceptors.add(new Dot11FrameInterceptor<Dot11DeauthenticationFrame>(){

            @Override
            public void intercept(Dot11DeauthenticationFrame frame) {
                BanditIdentifierInterceptorSet.this.ci.identify(frame);
            }

            @Override
            public byte forSubtype() {
                return 12;
            }

            @Override
            public List<Class<? extends Alert>> raisesAlerts() {
                return Collections.emptyList();
            }
        });
        return interceptors.build();
    }
}

