/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.dot11.frames;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.auto.value.AutoValue;
import horse.wtf.nzyme.dot11.Dot11MetaInformation;
import horse.wtf.nzyme.dot11.Dot11TaggedParameters;
import horse.wtf.nzyme.dot11.frames.AutoValue_Dot11BeaconFrame;
import horse.wtf.nzyme.dot11.frames.Dot11Frame;
import javax.annotation.Nullable;

@AutoValue
public abstract class Dot11BeaconFrame
implements Dot11Frame {
    @Nullable
    public abstract String ssid();

    public abstract String transmitter();

    public abstract String transmitterFingerprint();

    public abstract Dot11TaggedParameters taggedParameters();

    @Override
    public abstract Dot11MetaInformation meta();

    @Override
    public abstract byte[] payload();

    @Override
    public abstract byte[] header();

    @Override
    public abstract byte frameType();

    @JsonIgnore
    public String descriptionString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TYPE:        BEACON").append("\n");
        sb.append("SSID:        ").append(this.ssid()).append("\n");
        sb.append("Transmitter: ").append(this.transmitter()).append("\n");
        sb.append("Fingerprint: ").append(this.transmitterFingerprint()).append("\n");
        sb.append("WPS:         ").append(this.taggedParameters().isWPS()).append("\n");
        sb.append("Security:    ").append(this.taggedParameters().getFullSecurityString()).append("\n");
        return sb.toString();
    }

    public static Dot11BeaconFrame create(String ssid, String transmitter, String transmitterFingerprint, Dot11TaggedParameters taggedParameters, Dot11MetaInformation meta, byte[] payload, byte[] header) {
        return Dot11BeaconFrame.builder().ssid(ssid).transmitter(transmitter).transmitterFingerprint(transmitterFingerprint).taggedParameters(taggedParameters).meta(meta).payload(payload).header(header).frameType((byte)8).build();
    }

    public static Builder builder() {
        return new AutoValue_Dot11BeaconFrame.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder ssid(String var1);

        public abstract Builder transmitter(String var1);

        public abstract Builder transmitterFingerprint(String var1);

        public abstract Builder taggedParameters(Dot11TaggedParameters var1);

        public abstract Builder meta(Dot11MetaInformation var1);

        public abstract Builder payload(byte[] var1);

        public abstract Builder header(byte[] var1);

        public abstract Builder frameType(byte var1);

        public abstract Dot11BeaconFrame build();
    }
}

