/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.dot11.frames;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.auto.value.AutoValue;
import horse.wtf.nzyme.dot11.Dot11MetaInformation;
import horse.wtf.nzyme.dot11.frames.AutoValue_Dot11AssociationRequestFrame;
import horse.wtf.nzyme.dot11.frames.Dot11Frame;
import javax.annotation.Nullable;

@AutoValue
public abstract class Dot11AssociationRequestFrame
implements Dot11Frame {
    @Nullable
    public abstract String ssid();

    public abstract String destination();

    public abstract String transmitter();

    @Override
    public abstract Dot11MetaInformation meta();

    @Override
    public abstract byte[] payload();

    @Override
    public abstract byte[] header();

    @Override
    public abstract byte frameType();

    @JsonIgnore
    public String descriptionString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TYPE:        ASSOCIATION REQUEST").append("\n");
        sb.append("SSID:        ").append(this.ssid()).append("\n");
        sb.append("Transmitter: ").append(this.transmitter()).append("\n");
        sb.append("Destination: ").append(this.destination()).append("\n");
        return sb.toString();
    }

    public static Dot11AssociationRequestFrame create(String ssid, String destination, String transmitter, Dot11MetaInformation meta, byte[] payload, byte[] header) {
        return Dot11AssociationRequestFrame.builder().ssid(ssid).destination(destination).transmitter(transmitter).meta(meta).payload(payload).header(header).frameType((byte)0).build();
    }

    public static Builder builder() {
        return new AutoValue_Dot11AssociationRequestFrame.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder ssid(String var1);

        public abstract Builder destination(String var1);

        public abstract Builder transmitter(String var1);

        public abstract Builder meta(Dot11MetaInformation var1);

        public abstract Builder payload(byte[] var1);

        public abstract Builder header(byte[] var1);

        public abstract Builder frameType(byte var1);

        public abstract Dot11AssociationRequestFrame build();
    }
}

