/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.dot11;

import horse.wtf.nzyme.channels.Frequencies;
import horse.wtf.nzyme.util.Tools;
import java.util.ArrayList;
import org.pcap4j.packet.RadiotapDataAMpduStatus;
import org.pcap4j.packet.RadiotapDataAntennaSignal;
import org.pcap4j.packet.RadiotapDataChannel;
import org.pcap4j.packet.RadiotapDataFlags;
import org.pcap4j.packet.RadiotapDataRxFlags;
import org.pcap4j.packet.RadiotapDataTsft;
import org.pcap4j.packet.RadiotapPacket;

public class Dot11MetaInformation {
    private final boolean malformed;
    private final int antennaSignal;
    private final int signalQuality;
    private final int frequency;
    private final int channel;
    private final long macTimestamp;
    private final boolean isWep;

    public Dot11MetaInformation(boolean malformed, int antennaSignal, int frequency, int channel, long macTimestamp, boolean isWep) {
        this.malformed = malformed;
        this.antennaSignal = antennaSignal;
        this.signalQuality = Tools.calculateSignalQuality(antennaSignal);
        this.channel = channel;
        this.frequency = frequency;
        this.macTimestamp = macTimestamp;
        this.isWep = isWep;
    }

    public boolean isMalformed() {
        return this.malformed;
    }

    public int getAntennaSignal() {
        return this.antennaSignal;
    }

    public int getSignalQuality() {
        return this.signalQuality;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public long getMacTimestamp() {
        return this.macTimestamp;
    }

    public int getChannel() {
        return this.channel;
    }

    public boolean isWep() {
        return this.isWep;
    }

    public static Dot11MetaInformation parse(ArrayList<RadiotapPacket.RadiotapData> dataFields) {
        int antennaSignal = 0;
        int frequency = 0;
        int channel = -1;
        boolean delimiterCrcError = false;
        boolean badPlcpCrc = false;
        boolean badFcs = false;
        boolean isWep = false;
        long macTimestamp = -1L;
        boolean antennaRead = false;
        for (RadiotapPacket.RadiotapData f2 : dataFields) {
            if (f2 instanceof RadiotapDataAntennaSignal) {
                if (antennaRead) continue;
                antennaSignal = ((RadiotapDataAntennaSignal)f2).getAntennaSignalAsInt();
                antennaRead = true;
                continue;
            }
            if (f2 instanceof RadiotapDataChannel) {
                frequency = ((RadiotapDataChannel)f2).getFrequencyAsInt();
                channel = Frequencies.frequencyToChannel(frequency);
                continue;
            }
            if (f2 instanceof RadiotapDataAMpduStatus) {
                delimiterCrcError = ((RadiotapDataAMpduStatus)f2).isDelimiterCrcError();
                continue;
            }
            if (f2 instanceof RadiotapDataRxFlags) {
                badPlcpCrc = ((RadiotapDataRxFlags)f2).isBadPlcpCrc();
                continue;
            }
            if (f2 instanceof RadiotapDataFlags) {
                badFcs = ((RadiotapDataFlags)f2).isBadFcs();
                isWep = ((RadiotapDataFlags)f2).isWepEncrypted();
                continue;
            }
            if (!(f2 instanceof RadiotapDataTsft)) continue;
            macTimestamp = ((RadiotapDataTsft)f2).getMacTimestamp().longValue();
        }
        return new Dot11MetaInformation(delimiterCrcError || badPlcpCrc || badFcs, antennaSignal, frequency, channel, macTimestamp, isWep);
    }
}

