/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.configuration.leader;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import horse.wtf.nzyme.Role;
import horse.wtf.nzyme.alerts.Alert;
import horse.wtf.nzyme.alerts.service.callbacks.AlertCallback;
import horse.wtf.nzyme.configuration.DeauthenticationMonitorConfiguration;
import horse.wtf.nzyme.configuration.Dot11BSSIDDefinition;
import horse.wtf.nzyme.configuration.Dot11MonitorDefinition;
import horse.wtf.nzyme.configuration.Dot11NetworkDefinition;
import horse.wtf.nzyme.configuration.Dot11TrapDeviceDefinition;
import horse.wtf.nzyme.configuration.ForwarderDefinition;
import horse.wtf.nzyme.configuration.ReportingConfiguration;
import horse.wtf.nzyme.configuration.UplinkDefinition;
import horse.wtf.nzyme.configuration.UplinkDeviceConfiguration;
import horse.wtf.nzyme.configuration.leader.AutoValue_LeaderConfiguration;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.file.Path;
import javax.annotation.Nullable;

@AutoValue
public abstract class LeaderConfiguration {
    public abstract boolean versionchecksEnabled();

    public abstract boolean fetchOuis();

    public abstract Role role();

    public abstract String adminPasswordHash();

    public abstract String databasePath();

    public abstract String pythonExecutable();

    public abstract String pythonScriptDirectory();

    public abstract String pythonScriptPrefix();

    public abstract URI restListenUri();

    public abstract URI httpExternalUri();

    public abstract boolean useTls();

    @Nullable
    public abstract Path tlsCertificatePath();

    @Nullable
    public abstract Path tlsKeyPath();

    @Nullable
    public abstract InetSocketAddress remoteInputAddress();

    public abstract ImmutableList<UplinkDefinition> uplinks();

    public abstract ImmutableList<Dot11MonitorDefinition> dot11Monitors();

    public abstract ImmutableList<Dot11NetworkDefinition> dot11Networks();

    public abstract ImmutableList<Dot11TrapDeviceDefinition> dot11TrapDevices();

    public abstract ImmutableList<Alert.TYPE_WIDE> dot11Alerts();

    public abstract int alertingTrainingPeriodSeconds();

    public abstract ImmutableList<AlertCallback> alertCallbacks();

    public abstract ImmutableList<ForwarderDefinition> forwarders();

    @Nullable
    public abstract UplinkDeviceConfiguration groundstationDevice();

    @Nullable
    public abstract ReportingConfiguration reporting();

    @Nullable
    public abstract DeauthenticationMonitorConfiguration deauth();

    public ImmutableList<String> ourSSIDs() {
        ImmutableList.Builder ssids = new ImmutableList.Builder();
        this.dot11Networks().forEach(n2 -> ssids.add(n2.ssid()));
        return ssids.build();
    }

    public static LeaderConfiguration create(boolean versionchecksEnabled, boolean fetchOuis, Role role, String adminPasswordHash, String databasePath, String pythonExecutable, String pythonScriptDirectory, String pythonScriptPrefix, URI restListenUri, URI httpExternalUri, boolean useTls, Path tlsCertificatePath, Path tlsKeyPath, InetSocketAddress remoteInputAddress, ImmutableList<UplinkDefinition> uplinks, ImmutableList<Dot11MonitorDefinition> dot11Monitors, ImmutableList<Dot11NetworkDefinition> dot11Networks, ImmutableList<Dot11TrapDeviceDefinition> dot11TrapDevices, ImmutableList<Alert.TYPE_WIDE> dot11Alerts, int alertingTrainingPeriodSeconds, ImmutableList<AlertCallback> alertCallbacks, ImmutableList<ForwarderDefinition> forwarders, UplinkDeviceConfiguration groundstationDevice, ReportingConfiguration reporting, DeauthenticationMonitorConfiguration deauth) {
        return LeaderConfiguration.builder().versionchecksEnabled(versionchecksEnabled).fetchOuis(fetchOuis).role(role).adminPasswordHash(adminPasswordHash).databasePath(databasePath).pythonExecutable(pythonExecutable).pythonScriptDirectory(pythonScriptDirectory).pythonScriptPrefix(pythonScriptPrefix).restListenUri(restListenUri).httpExternalUri(httpExternalUri).useTls(useTls).tlsCertificatePath(tlsCertificatePath).tlsKeyPath(tlsKeyPath).remoteInputAddress(remoteInputAddress).uplinks(uplinks).dot11Monitors(dot11Monitors).dot11Networks(dot11Networks).dot11TrapDevices(dot11TrapDevices).dot11Alerts(dot11Alerts).alertingTrainingPeriodSeconds(alertingTrainingPeriodSeconds).alertCallbacks(alertCallbacks).forwarders(forwarders).groundstationDevice(groundstationDevice).reporting(reporting).deauth(deauth).build();
    }

    @Nullable
    public Dot11NetworkDefinition findNetworkDefinition(String bssid, String ssid) {
        for (Dot11NetworkDefinition network : this.dot11Networks()) {
            if (!network.allBSSIDAddresses().contains(bssid) || !network.ssid().equals(ssid)) continue;
            return network;
        }
        return null;
    }

    @Nullable
    public Dot11BSSIDDefinition findBSSIDDefinition(String bssid, String ssid) {
        Dot11NetworkDefinition networkDefinition = this.findNetworkDefinition(bssid, ssid);
        if (networkDefinition != null) {
            for (Dot11BSSIDDefinition dot11BSSIDDefinition : networkDefinition.bssids()) {
                if (!dot11BSSIDDefinition.address().equals(bssid)) continue;
                return dot11BSSIDDefinition;
            }
        }
        return null;
    }

    public static Builder builder() {
        return new AutoValue_LeaderConfiguration.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder versionchecksEnabled(boolean var1);

        public abstract Builder fetchOuis(boolean var1);

        public abstract Builder role(Role var1);

        public abstract Builder adminPasswordHash(String var1);

        public abstract Builder databasePath(String var1);

        public abstract Builder pythonExecutable(String var1);

        public abstract Builder pythonScriptDirectory(String var1);

        public abstract Builder pythonScriptPrefix(String var1);

        public abstract Builder restListenUri(URI var1);

        public abstract Builder httpExternalUri(URI var1);

        public abstract Builder useTls(boolean var1);

        public abstract Builder tlsCertificatePath(Path var1);

        public abstract Builder tlsKeyPath(Path var1);

        public abstract Builder remoteInputAddress(InetSocketAddress var1);

        public abstract Builder uplinks(ImmutableList<UplinkDefinition> var1);

        public abstract Builder dot11Monitors(ImmutableList<Dot11MonitorDefinition> var1);

        public abstract Builder dot11Networks(ImmutableList<Dot11NetworkDefinition> var1);

        public abstract Builder dot11TrapDevices(ImmutableList<Dot11TrapDeviceDefinition> var1);

        public abstract Builder dot11Alerts(ImmutableList<Alert.TYPE_WIDE> var1);

        public abstract Builder alertingTrainingPeriodSeconds(int var1);

        public abstract Builder alertCallbacks(ImmutableList<AlertCallback> var1);

        public abstract Builder forwarders(ImmutableList<ForwarderDefinition> var1);

        public abstract Builder groundstationDevice(UplinkDeviceConfiguration var1);

        public abstract Builder reporting(ReportingConfiguration var1);

        public abstract Builder deauth(DeauthenticationMonitorConfiguration var1);

        public abstract LeaderConfiguration build();
    }
}

