/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.configuration.base;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import horse.wtf.nzyme.Role;
import horse.wtf.nzyme.configuration.ConfigurationValidator;
import horse.wtf.nzyme.configuration.IncompleteConfigurationException;
import horse.wtf.nzyme.configuration.InvalidConfigurationException;
import horse.wtf.nzyme.configuration.base.BaseConfiguration;
import horse.wtf.nzyme.util.Tools;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Files;

public class BaseConfigurationLoader {
    private final Config general;

    public BaseConfigurationLoader(File configFile) throws InvalidConfigurationException, IncompleteConfigurationException, FileNotFoundException {
        if (!Files.isReadable(configFile.toPath())) {
            throw new FileNotFoundException("File at [" + configFile.getPath() + "] does not exist or is not readable. Check path and permissions.");
        }
        Config root = ConfigFactory.parseFile(configFile).resolve();
        try {
            this.general = root.getConfig("general");
        }
        catch (ConfigException e2) {
            throw new IncompleteConfigurationException("Incomplete configuration.", e2);
        }
        this.validate();
    }

    public BaseConfiguration get() {
        return BaseConfiguration.create(this.parseNodeID(), this.parseRole(), this.parseDataDirectory(), this.parseAnonymize());
    }

    public String parseNodeID() {
        return this.general.getString("id");
    }

    public Role parseRole() {
        return this.general.getEnum(Role.class, "role");
    }

    private String parseDataDirectory() {
        return this.general.getString("data_directory");
    }

    public boolean parseAnonymize() {
        if (!this.general.hasPath("anonymize")) {
            return false;
        }
        return this.general.getBoolean("anonymize");
    }

    public void validate() throws InvalidConfigurationException, IncompleteConfigurationException {
        ConfigurationValidator.expectEnum(this.general, "role", "general", Role.class);
        ConfigurationValidator.expect(this.general, "id", "general", String.class);
        if (!Tools.isSafeID(this.parseNodeID())) {
            throw new InvalidConfigurationException("Node ID must only contain alphanumeric characters, underscores or dashes.");
        }
        File dataDirectory = new File(this.parseDataDirectory());
        if (!dataDirectory.exists()) {
            throw new InvalidConfigurationException("Data directory [" + this.parseDataDirectory() + "] does not exist.");
        }
        if (!dataDirectory.isDirectory()) {
            throw new InvalidConfigurationException("Data directory [" + this.parseDataDirectory() + "] is not a directory.");
        }
        if (!dataDirectory.canWrite()) {
            throw new InvalidConfigurationException("Data directory [" + this.parseDataDirectory() + "] is not writable.");
        }
    }
}

