/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.configuration;

import com.google.auto.value.AutoValue;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.typesafe.config.Config;
import horse.wtf.nzyme.configuration.AutoValue_Dot11MonitorDefinition;

@AutoValue
public abstract class Dot11MonitorDefinition {
    public abstract String device();

    public abstract ImmutableList<Integer> channels();

    public abstract String channelHopCommand();

    public abstract Integer channelHopInterval();

    public abstract boolean skipEnableMonitor();

    public abstract int maxIdleTimeSeconds();

    public static Dot11MonitorDefinition create(String device, ImmutableList<Integer> channels, String channelHopCommand, Integer channelHopInterval, boolean skipEnableMonitor, int maxIdleTimeSeconds) {
        return Dot11MonitorDefinition.builder().device(device).channels(channels).channelHopCommand(channelHopCommand).channelHopInterval(channelHopInterval).skipEnableMonitor(skipEnableMonitor).maxIdleTimeSeconds(maxIdleTimeSeconds).build();
    }

    public static boolean checkConfig(Config c2) {
        return !Strings.isNullOrEmpty(c2.getString("device")) && c2.getIntList("channels") != null && !c2.getIntList("channels").isEmpty() && !Strings.isNullOrEmpty(c2.getString("channel_hop_command")) && c2.getInt("channel_hop_interval") >= 0;
    }

    public static Builder builder() {
        return new AutoValue_Dot11MonitorDefinition.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder device(String var1);

        public abstract Builder channels(ImmutableList<Integer> var1);

        public abstract Builder channelHopCommand(String var1);

        public abstract Builder channelHopInterval(Integer var1);

        public abstract Builder skipEnableMonitor(boolean var1);

        public abstract Builder maxIdleTimeSeconds(int var1);

        public abstract Dot11MonitorDefinition build();
    }
}

