/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.configuration;

import com.beust.jcommander.internal.Lists;
import com.google.common.collect.ImmutableList;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import horse.wtf.nzyme.configuration.ConfigurationValidator;
import horse.wtf.nzyme.configuration.Dot11BSSIDDefinition;
import horse.wtf.nzyme.configuration.Dot11MonitorDefinition;
import horse.wtf.nzyme.configuration.Dot11NetworkDefinition;
import horse.wtf.nzyme.configuration.IncompleteConfigurationException;
import horse.wtf.nzyme.configuration.InvalidConfigurationException;
import horse.wtf.nzyme.dot11.networks.signalstrength.tracks.TrackDetector;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BaseDot11ConfigurationLoader {
    private static final Logger LOG = LogManager.getLogger(BaseDot11ConfigurationLoader.class);
    private final Config root;

    public BaseDot11ConfigurationLoader(Config root) {
        this.root = root;
    }

    public ImmutableList<Dot11MonitorDefinition> parseDot11Monitors() {
        ImmutableList.Builder result = new ImmutableList.Builder();
        for (Config config : this.root.getConfigList("802_11_monitors")) {
            if (!Dot11MonitorDefinition.checkConfig(config)) {
                LOG.info("Skipping 802.11 monitor with invalid configuration. Invalid monitor: [{}]", (Object)config);
                continue;
            }
            boolean skipEnableMonitor = config.hasPath("skip_enable_monitor") ? config.getBoolean("skip_enable_monitor") : false;
            int maxIdleTimeSeconds = config.hasPath("max_idle_time_seconds") ? config.getInt("max_idle_time_seconds") : 60;
            result.add(Dot11MonitorDefinition.create(config.getString("device"), ImmutableList.copyOf(config.getIntList("channels")), config.getString("channel_hop_command"), config.getInt("channel_hop_interval"), skipEnableMonitor, maxIdleTimeSeconds));
        }
        return result.build();
    }

    public ImmutableList<Dot11NetworkDefinition> parseDot11Networks() {
        ImmutableList.Builder result = new ImmutableList.Builder();
        for (Config config : this.root.getConfigList("802_11_networks")) {
            if (!Dot11NetworkDefinition.checkConfig(config)) {
                LOG.info("Skipping 802.11 network with invalid configuration. Invalid network: [{}]", (Object)config);
                continue;
            }
            ImmutableList.Builder lowercaseBSSIDs = new ImmutableList.Builder();
            for (Config config2 : config.getConfigList("bssids")) {
                TrackDetector.TrackDetectorConfig trackDetectorConfig = null;
                if (config2.hasPath("track_detector")) {
                    Config tdc = config2.getConfig("track_detector");
                    if (tdc.hasPath("frame_threshold") && tdc.hasPath("gap_threshold") && tdc.hasPath("signal_centerline_jitter")) {
                        trackDetectorConfig = TrackDetector.TrackDetectorConfig.create(tdc.getInt("frame_threshold"), tdc.getInt("gap_threshold"), tdc.getInt("signal_centerline_jitter"));
                    } else {
                        LOG.warn("Not parsing track detector config. Missing at least one configuration key. Please consult documentation.");
                    }
                }
                lowercaseBSSIDs.add(Dot11BSSIDDefinition.create(config2.getString("address").toLowerCase(), config2.getStringList("fingerprints"), trackDetectorConfig));
            }
            result.add(Dot11NetworkDefinition.create(config.getString("ssid"), (List<Dot11BSSIDDefinition>)((Object)lowercaseBSSIDs.build()), config.getIntList("channels"), config.getStringList("security"), config.getInt("beacon_rate")));
        }
        return result.build();
    }

    public void validate() throws InvalidConfigurationException, IncompleteConfigurationException {
        this.validateMonitors();
        this.validateNetworks();
    }

    public void validateMonitors() throws IncompleteConfigurationException, InvalidConfigurationException {
        int i2 = 0;
        for (Config config : this.root.getConfigList("802_11_monitors")) {
            String where = "802_11_monitors.#" + i2;
            ConfigurationValidator.expect(config, "device", where, String.class);
            ConfigurationValidator.expect(config, "channels", where, ImmutableList.class);
            ConfigurationValidator.expect(config, "channel_hop_command", where, String.class);
            ConfigurationValidator.expect(config, "channel_hop_interval", where, Integer.class);
            ++i2;
        }
        this.validateChannelList("802_11_monitors");
        List usedChannels = Lists.newArrayList();
        for (Dot11MonitorDefinition monitor : this.parseDot11Monitors()) {
            for (Integer channel : monitor.channels()) {
                if (!usedChannels.contains(channel)) continue;
                throw new InvalidConfigurationException("Channel [" + channel + "] is defined for multiple 802.11 monitors. You should not have multiple monitors tuned to the same channel.");
            }
            usedChannels.addAll(monitor.channels());
        }
        List list = Lists.newArrayList();
        for (Dot11MonitorDefinition monitor : this.parseDot11Monitors()) {
            if (list.contains(monitor.device())) {
                throw new InvalidConfigurationException("Device [" + monitor.device() + "] is defined for multiple 802.11 monitors. You should not have multiple monitors using the same device.");
            }
            list.add(monitor.device());
        }
    }

    public void validateNetworks() throws IncompleteConfigurationException, InvalidConfigurationException {
        List ssids = Lists.newArrayList();
        for (Dot11NetworkDefinition net : this.parseDot11Networks()) {
            if (ssids.contains(net.ssid())) {
                throw new InvalidConfigurationException("SSID [" + net.ssid() + "] is defined multiple times. You cannot define a network with the same SSID more than once.");
            }
            ssids.add(net.ssid());
        }
        for (Dot11NetworkDefinition net : this.parseDot11Networks()) {
            List bssids = Lists.newArrayList();
            for (Dot11BSSIDDefinition bssid : net.bssids()) {
                if (bssids.contains(bssid.address())) {
                    throw new InvalidConfigurationException("Network [" + net.ssid() + "] has at least one BSSID defined twice. You cannot define a BSSID for the same network more than once.");
                }
                bssids.add(bssid.address());
            }
        }
    }

    private void validateChannelList(String key) throws InvalidConfigurationException {
        int x2 = 0;
        List usedChannels = Lists.newArrayList();
        for (Config config : this.root.getConfigList(key)) {
            String where = key + ".#" + x2;
            try {
                for (Integer channel : config.getIntList("channels")) {
                    if (channel < 1) {
                        throw new InvalidConfigurationException("Invalid channels in list for [" + where + "}. All channels must be integers larger than 0.");
                    }
                    if (usedChannels.contains(channel)) {
                        throw new InvalidConfigurationException("Duplicate channel <" + channel + "> in list for [ " + where + " ]. Channels cannot be duplicate per monitor or across multiple monitors.");
                    }
                    usedChannels.add(channel);
                }
            }
            catch (ConfigException e2) {
                LOG.error(e2);
                throw new InvalidConfigurationException("Invalid channels list for [" + where + "}. All channels must be integers larger than 0.");
            }
            finally {
                ++x2;
            }
        }
    }
}

