/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.bandits.trackers.trackerlogic;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import horse.wtf.nzyme.NzymeTracker;
import horse.wtf.nzyme.bandits.trackers.TrackerState;
import horse.wtf.nzyme.bandits.trackers.protobuf.TrackerMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.joda.time.DateTime;

public class TrackerStateWatchdog {
    public static final int WEAK_RSSI_LIMIT = 165;
    private final NzymeTracker nzyme;
    private final AtomicReference<List<TrackerState>> states;
    private final AtomicReference<Optional<DateTime>> lastPingReceived;
    private final AtomicReference<Optional<Integer>> lastRSSIReceived;

    public TrackerStateWatchdog(NzymeTracker nzyme) {
        this.nzyme = nzyme;
        this.states = new AtomicReference<1>(new ArrayList<TrackerState>(){
            {
                this.add(TrackerState.DARK);
            }
        });
        this.lastPingReceived = new AtomicReference(Optional.empty());
        this.lastRSSIReceived = new AtomicReference(Optional.empty());
    }

    public void initialize() {
        Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("trackerstate-watchdog-%d").build()).scheduleAtFixedRate(() -> {
            ArrayList previousState = Lists.newArrayList((Iterable)this.states.get());
            ArrayList<TrackerState> result = Lists.newArrayList();
            if (this.lastPingReceived.get().isEmpty()) {
                result.add(TrackerState.DARK);
            } else {
                this.lastPingReceived.get().ifPresent(time -> {
                    if (time.isAfter(DateTime.now().minusSeconds(20))) {
                        result.add(TrackerState.ONLINE);
                        this.lastRSSIReceived.get().ifPresent(rssi -> {
                            if (rssi < 165) {
                                result.add(TrackerState.WEAK);
                            }
                        });
                    } else {
                        result.add(TrackerState.DARK);
                    }
                });
            }
            this.states.set(result);
            Collections.sort(result);
            Collections.sort(previousState);
            if (!result.equals(previousState)) {
                this.stateChanged();
            }
        }, 5L, 10L, TimeUnit.SECONDS);
    }

    public void registerPing(TrackerMessage.Ping ping, int rssi) {
        if (ping.getNodeType() != TrackerMessage.Ping.NodeType.LEADER) {
            return;
        }
        this.lastPingReceived.set(Optional.of(DateTime.now()));
        this.lastRSSIReceived.set(Optional.of(rssi));
    }

    public List<TrackerState> getStates() {
        return new ArrayList<TrackerState>((Collection)this.states.get());
    }

    private void stateChanged() {
        this.nzyme.getGroundStation().handleTrackerConnectionStateChange(this.states.get());
    }
}

