/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.bandits.trackers.trackerlogic;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import horse.wtf.nzyme.dot11.probes.Dot11MonitorProbe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChannelDesignator {
    private static final Logger LOG = LogManager.getLogger(ChannelDesignator.class);
    private static final short SWEEP_BREAK = 5;
    private final Dot11MonitorProbe probe;
    private final AtomicReference<List<Integer>> designatedChannels;
    private final AtomicBoolean contactDuringCycle;
    private final AtomicReference<DESIGNATION_STATUS> status;
    private short loopCount;

    public ChannelDesignator(Dot11MonitorProbe probe) {
        this.probe = probe;
        this.contactDuringCycle = new AtomicBoolean(false);
        this.status = new AtomicReference<DESIGNATION_STATUS>(DESIGNATION_STATUS.UNLOCKED);
        this.designatedChannels = new AtomicReference<ArrayList<Integer>>(new ArrayList<Integer>(probe.getConfiguration().channels()));
        Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("channel-designator-%d").build()).scheduleAtFixedRate(this::designate, 0L, 30L, TimeUnit.SECONDS);
        LOG.info("Channel Designator is online.");
    }

    public void onBanditTrace(int channel) {
        this.contactDuringCycle.set(true);
        if (!this.designatedChannels.get().contains(channel)) {
            this.designatedChannels.get().add(channel);
        }
    }

    public DESIGNATION_STATUS getStatus() {
        return this.status.get();
    }

    private void designate() {
        boolean skip = false;
        if (this.loopCount == 4) {
            this.loopCount = 0;
            if (this.contactDuringCycle.get()) {
                LOG.info("Starting designator sweep.");
                this.probe.getChannelHopper().setChannels(this.probe.getConfiguration().channels());
                this.status.set(DESIGNATION_STATUS.SWEEPING);
                skip = true;
            }
        }
        if (!skip) {
            if (this.contactDuringCycle.get()) {
                LOG.info("Contacts recorded during cycle. Designating channels [{}].", (Object)Joiner.on(",").join((Iterable)this.designatedChannels.get()));
                this.probe.getChannelHopper().setChannels(this.intersectChannels(new ArrayList<Integer>((Collection)this.designatedChannels.get()), this.probe.getConfiguration().channels()));
                this.status.set(DESIGNATION_STATUS.LOCKED);
            } else {
                LOG.info("No contacts during cycle. Resuming operations on configured probe channels.");
                this.probe.getChannelHopper().setChannels(this.probe.getConfiguration().channels());
                this.status.set(DESIGNATION_STATUS.UNLOCKED);
            }
        }
        this.contactDuringCycle.set(false);
        this.designatedChannels.get().clear();
        this.loopCount = (short)(this.loopCount + 1);
    }

    private List<Integer> intersectChannels(List<Integer> partial, List<Integer> complete) {
        ImmutableList.Builder result = new ImmutableList.Builder();
        for (Integer x2 : partial) {
            if (!complete.contains(x2)) continue;
            result.add(x2);
        }
        return result.build();
    }

    public static enum DESIGNATION_STATUS {
        LOCKED,
        UNLOCKED,
        SWEEPING;

    }
}

