/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.bandits.trackers.hid.webhid;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import com.google.auto.value.AutoValue;
import com.google.common.collect.EvictingQueue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import horse.wtf.nzyme.NzymeTracker;
import horse.wtf.nzyme.bandits.Bandit;
import horse.wtf.nzyme.bandits.trackers.TrackerState;
import horse.wtf.nzyme.bandits.trackers.hid.TrackerHID;
import horse.wtf.nzyme.bandits.trackers.hid.webhid.AutoValue_WebHID_Event;
import horse.wtf.nzyme.bandits.trackers.hid.webhid.rest.NzymeTrackerInjectionBinder;
import horse.wtf.nzyme.bandits.trackers.hid.webhid.rest.resources.TrackerWebHIDAssetsResource;
import horse.wtf.nzyme.bandits.trackers.hid.webhid.rest.resources.TrackerWebHIDResource;
import horse.wtf.nzyme.bandits.trackers.protobuf.TrackerMessage;
import horse.wtf.nzyme.bandits.trackers.trackerlogic.ChannelDesignator;
import horse.wtf.nzyme.dot11.probes.Dot11MonitorProbe;
import horse.wtf.nzyme.dot11.probes.Dot11Probe;
import horse.wtf.nzyme.rest.CORSFilter;
import horse.wtf.nzyme.rest.NzymeExceptionMapper;
import horse.wtf.nzyme.rest.ObjectMapperProvider;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.logging.log4j.LogManager;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.message.DeflateEncoder;
import org.glassfish.jersey.message.GZipEncoder;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.filter.EncodingFilter;
import org.joda.time.DateTime;

public class WebHID
implements TrackerHID {
    private static final org.apache.logging.log4j.Logger LOG = LogManager.getLogger(WebHID.class);
    private final NzymeTracker nzyme;
    private int leaderRSSI = 0;
    private boolean trackerDeviceLive = false;
    private boolean allProbesLive = false;
    private ChannelDesignator.DESIGNATION_STATUS channelDesignationStatus = ChannelDesignator.DESIGNATION_STATUS.UNLOCKED;
    private final EvictingQueue<Event> events;

    public WebHID(NzymeTracker nzyme) {
        this.nzyme = nzyme;
        this.events = EvictingQueue.create(20);
    }

    @Override
    public void initialize() {
        Logger.getLogger("org.glassfish.grizzly").setLevel(Level.SEVERE);
        ResourceConfig resourceConfig = new ResourceConfig();
        resourceConfig.register(new NzymeTrackerInjectionBinder(this.nzyme, this));
        resourceConfig.register(new CORSFilter());
        resourceConfig.register(new ObjectMapperProvider());
        resourceConfig.register(new JacksonJaxbJsonProvider());
        resourceConfig.register(new NzymeExceptionMapper());
        resourceConfig.register((Class)TrackerWebHIDResource.class);
        resourceConfig.registerClasses(EncodingFilter.class, GZipEncoder.class, DeflateEncoder.class);
        resourceConfig.register((Class)TrackerWebHIDAssetsResource.class);
        URI listenURI = URI.create("http://0.0.0.0:13000");
        HttpServer httpServer = GrizzlyHttpServerFactory.createHttpServer(listenURI, resourceConfig);
        try {
            httpServer.start();
        }
        catch (IOException e2) {
            throw new RuntimeException("Could not start REST API.", e2);
        }
        Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("webhid-secup-%d").build()).scheduleWithFixedDelay(() -> {
            this.allProbesLive = true;
            Dot11MonitorProbe firstMonitor = null;
            for (Dot11Probe probe : this.nzyme.getProbes()) {
                if (probe.isInLoop() && probe.isActive()) continue;
                this.allProbesLive = false;
                break;
            }
            for (Dot11Probe probe : this.nzyme.getProbes()) {
                if (!(probe instanceof Dot11MonitorProbe)) continue;
                firstMonitor = (Dot11MonitorProbe)probe;
                break;
            }
            if (firstMonitor != null) {
                this.channelDesignationStatus = firstMonitor.getChannelDesignator().getStatus();
            }
            this.trackerDeviceLive = this.nzyme.getGroundStation().getTrackerDevice().isHealthy();
        }, 0L, 1L, TimeUnit.SECONDS);
        LOG.info("Started WebHID and REST API at [{}].", (Object)listenURI);
    }

    @Override
    public void onConnectionStateChange(List<TrackerState> connectionState) {
    }

    @Override
    public void onPingFromLeaderReceived(TrackerMessage.Ping ping, int rssi) {
        this.leaderRSSI = rssi;
    }

    @Override
    public void onPingFromTrackerReceived(TrackerMessage.Ping ping, int rssi) {
    }

    @Override
    public void onStartTrackingRequestReceived(TrackerMessage.StartTrackRequest request) {
        this.event(request.getSource(), "Received request to track bandit.");
    }

    @Override
    public void onCancelTrackingRequestReceived(TrackerMessage.CancelTrackRequest request) {
        this.event(request.getSource(), "All bandit tracking canceled on leader request.");
    }

    @Override
    public void onInitialContactWithTrackedBandit(Bandit bandit) {
    }

    @Override
    public void onBanditTrace(Bandit bandit, int rssi) {
    }

    @Override
    public void onChannelSwitch(int previousChannel, int newChannel) {
    }

    private void event(String source2, String message) {
        this.events.add(Event.create(DateTime.now(), source2, message));
    }

    public List<Event> getEvents() {
        return ImmutableList.copyOf(this.events);
    }

    public int getLeaderRSSI() {
        return this.leaderRSSI;
    }

    public boolean isAllProbesLive() {
        return this.allProbesLive;
    }

    public boolean isTrackerDeviceLive() {
        return this.trackerDeviceLive;
    }

    public List<Integer> allMonitorChannels() {
        ArrayList<Integer> channels = Lists.newArrayList();
        for (Dot11Probe probe : this.nzyme.getProbes()) {
            channels.add(probe.getCurrentChannel());
        }
        return channels;
    }

    public ChannelDesignator.DESIGNATION_STATUS getChannelDesignationStatus() {
        return this.channelDesignationStatus;
    }

    @AutoValue
    public static abstract class Event {
        @JsonProperty
        public abstract DateTime timestamp();

        @JsonProperty
        public abstract String source();

        @JsonProperty
        public abstract String message();

        public static Event create(DateTime timestamp, String source2, String message) {
            return Event.builder().timestamp(timestamp).source(source2).message(message).build();
        }

        public static Builder builder() {
            return new AutoValue_WebHID_Event.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder timestamp(DateTime var1);

            public abstract Builder source(String var1);

            public abstract Builder message(String var1);

            public abstract Event build();
        }
    }
}

