/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.bandits.trackers;

import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import horse.wtf.nzyme.bandits.trackers.Tracker;
import horse.wtf.nzyme.bandits.trackers.TrackerState;
import horse.wtf.nzyme.bandits.trackers.protobuf.TrackerMessage;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.joda.time.DateTime;

public class TrackerManager {
    public static final int DARK_TIMEOUT_SECONDS = 30;
    private static final int RETENTION_MINUTES = 60;
    private final AtomicReference<Map<String, Tracker>> activeTrackers = new AtomicReference(Maps.newHashMap());

    public TrackerManager() {
        Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("tracker-manager-cleaner-%d").build()).scheduleAtFixedRate(() -> {
            HashMap<String, Tracker> copy = new HashMap<String, Tracker>(this.activeTrackers.get());
            HashMap<String, Tracker> result = Maps.newHashMap();
            for (Map.Entry tracker : copy.entrySet()) {
                if (!((Tracker)tracker.getValue()).getLastSeen().isAfter(DateTime.now().minusMinutes(60))) continue;
                result.put((String)tracker.getKey(), (Tracker)tracker.getValue());
            }
            this.activeTrackers.set(result);
        }, 60L, 1L, TimeUnit.MINUTES);
    }

    public void registerTrackerPing(TrackerMessage.Ping ping, int rssi) {
        if (!this.activeTrackers.get().containsKey(ping.getSource())) {
            this.activeTrackers.get().put(ping.getSource(), new Tracker(ping.getSource(), DateTime.now(), ping.getVersion(), ping.getTrackingMode(), rssi));
        } else {
            Tracker tracker = this.activeTrackers.get().get(ping.getSource());
            tracker.setLastSeen(DateTime.now());
            tracker.setVersion(ping.getVersion());
            tracker.setTrackingMode(ping.getTrackingMode());
            tracker.setRssi(rssi);
        }
    }

    public Map<String, Tracker> getTrackers() {
        return new HashMap<String, Tracker>(this.activeTrackers.get());
    }

    public static TrackerState decideTrackerState(Tracker tracker) {
        if (tracker.getLastSeen().isBefore(DateTime.now().minusSeconds(30))) {
            return TrackerState.DARK;
        }
        if (tracker.getRssi() < 165) {
            return TrackerState.WEAK;
        }
        return TrackerState.ONLINE;
    }
}

