/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.bandits.identifiers;

import horse.wtf.nzyme.bandits.identifiers.BanditIdentifier;
import horse.wtf.nzyme.bandits.identifiers.BanditIdentifierDescriptor;
import horse.wtf.nzyme.dot11.frames.Dot11BeaconFrame;
import horse.wtf.nzyme.dot11.frames.Dot11DeauthenticationFrame;
import horse.wtf.nzyme.dot11.frames.Dot11ProbeResponseFrame;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

public class SignalStrengthBanditIdentifier
extends BanditIdentifier {
    private final int from;
    private final int to;

    public SignalStrengthBanditIdentifier(int from, int to, Long databaseId, UUID uuid) {
        super(databaseId, uuid, BanditIdentifier.TYPE.SIGNAL_STRENGTH);
        if (from > 0 || to < -100 || from <= to) {
            throw new IllegalArgumentException();
        }
        this.from = from;
        this.to = to;
    }

    @Override
    public Map<String, Object> configuration() {
        return new HashMap<String, Object>(){
            {
                this.put("from", SignalStrengthBanditIdentifier.this.from);
                this.put("to", SignalStrengthBanditIdentifier.this.to);
            }
        };
    }

    @Override
    public BanditIdentifierDescriptor descriptor() {
        return BanditIdentifierDescriptor.create(BanditIdentifier.TYPE.SIGNAL_STRENGTH, "Matches if the frame signal strength is within expected range.", "(frame.signal_quality >= " + this.to + " AND frame.signal_quality <= " + this.from + ")");
    }

    @Override
    public Optional<Boolean> matches(Dot11DeauthenticationFrame frame) {
        return this.match(frame.meta().getAntennaSignal());
    }

    @Override
    public Optional<Boolean> matches(Dot11BeaconFrame frame) {
        return this.match(frame.meta().getAntennaSignal());
    }

    @Override
    public Optional<Boolean> matches(Dot11ProbeResponseFrame frame) {
        return this.match(frame.meta().getAntennaSignal());
    }

    private Optional<Boolean> match(int signalStrength) {
        return Optional.of(signalStrength >= this.to && signalStrength <= this.from);
    }
}

