/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.bandits.identifiers;

import horse.wtf.nzyme.bandits.identifiers.BanditIdentifier;
import horse.wtf.nzyme.bandits.identifiers.BanditIdentifierDescriptor;
import horse.wtf.nzyme.dot11.frames.Dot11BeaconFrame;
import horse.wtf.nzyme.dot11.frames.Dot11DeauthenticationFrame;
import horse.wtf.nzyme.dot11.frames.Dot11ProbeResponseFrame;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

public class FingerprintBanditIdentifier
extends BanditIdentifier {
    private final String fingerprint;

    public FingerprintBanditIdentifier(String fingerprint, Long databaseID, UUID uuid) {
        super(databaseID, uuid, BanditIdentifier.TYPE.FINGERPRINT);
        this.fingerprint = fingerprint;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    @Override
    public BanditIdentifierDescriptor descriptor() {
        return BanditIdentifierDescriptor.create(BanditIdentifier.TYPE.FINGERPRINT, "Matches if the frame fingerprint equals the expected fingerprint.", "frame.fingerprint == \"" + this.fingerprint + "\"");
    }

    @Override
    public Map<String, Object> configuration() {
        return new HashMap<String, Object>(){
            {
                this.put("fingerprint", FingerprintBanditIdentifier.this.fingerprint);
            }
        };
    }

    @Override
    public Optional<Boolean> matches(Dot11DeauthenticationFrame frame) {
        return Optional.empty();
    }

    @Override
    public Optional<Boolean> matches(Dot11BeaconFrame frame) {
        return this.match(frame.transmitterFingerprint());
    }

    @Override
    public Optional<Boolean> matches(Dot11ProbeResponseFrame frame) {
        return this.match(frame.transmitterFingerprint());
    }

    private Optional<Boolean> match(String receivedFingerprint) {
        if (receivedFingerprint == null) {
            return Optional.of(false);
        }
        return Optional.of(receivedFingerprint.equals(this.fingerprint));
    }
}

