/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.bandits.engine;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import horse.wtf.nzyme.NzymeLeader;
import horse.wtf.nzyme.Role;
import horse.wtf.nzyme.alerts.Alert;
import horse.wtf.nzyme.alerts.BanditContactAlert;
import horse.wtf.nzyme.bandits.Bandit;
import horse.wtf.nzyme.bandits.Contact;
import horse.wtf.nzyme.bandits.DefaultBandits;
import horse.wtf.nzyme.bandits.engine.ContactIdentifierEngine;
import horse.wtf.nzyme.bandits.engine.ContactIdentifierProcess;
import horse.wtf.nzyme.bandits.engine.ContactRecordAggregation;
import horse.wtf.nzyme.bandits.engine.ContactRecorder;
import horse.wtf.nzyme.bandits.engine.ContactRecorderHistogramEntry;
import horse.wtf.nzyme.bandits.identifiers.BanditIdentifier;
import horse.wtf.nzyme.bandits.trackers.Tracker;
import horse.wtf.nzyme.bandits.trackers.protobuf.TrackerMessage;
import horse.wtf.nzyme.dot11.frames.Dot11Frame;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import javax.validation.constraints.Null;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdbi.v3.core.result.ResultBearing;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.joda.time.DateTime;

public class ContactManager
implements ContactIdentifierProcess {
    private static final Logger LOG = LogManager.getLogger(ContactManager.class);
    private final NzymeLeader nzyme;
    private ImmutableMap<UUID, Contact> contacts;
    private ImmutableMap<UUID, Bandit> bandits;
    private final ContactIdentifierEngine identifierEngine;
    private final ContactRecorder contactRecorder;
    private static final int CONTACT_RECORDER_SYNC_FREQ = 60;

    public ContactManager(NzymeLeader nzyme) {
        this.nzyme = nzyme;
        this.identifierEngine = new ContactIdentifierEngine(nzyme.getMetrics());
        this.contactRecorder = new ContactRecorder(60, nzyme);
        DefaultBandits.seed(this);
    }

    public ContactRecorder getContactRecorder() {
        return this.contactRecorder;
    }

    public long registerBandit(Bandit bandit) {
        AtomicReference banditId = new AtomicReference();
        this.nzyme.getDatabase().useHandle(x2 -> x2.inTransaction(handle -> {
            ResultBearing result = ((Update)((Update)((Update)((Update)handle.createUpdate("INSERT INTO bandits(bandit_uuid, name, description, read_only, created_at, updated_at) VALUES(:bandit_uuid, :name, :description, :read_only, (current_timestamp at time zone 'UTC'), (current_timestamp at time zone 'UTC'))").bind("bandit_uuid", bandit.uuid())).bind("name", bandit.name())).bind("description", bandit.description())).bind("read_only", bandit.readOnly())).executeAndReturnGeneratedKeys("id");
            banditId.set(result.mapTo(Long.class).first());
            if (bandit.identifiers() != null) {
                for (BanditIdentifier identifier : bandit.identifiers()) {
                    String configuration;
                    try {
                        configuration = this.nzyme.getObjectMapper().writeValueAsString(identifier.configuration());
                    }
                    catch (Exception e2) {
                        throw new RuntimeException(e2);
                    }
                    ((Update)((Update)((Update)((Update)handle.createUpdate("INSERT INTO bandit_identifiers(bandit_id, identifier_uuid, identifier_type, configuration, created_at, updated_at) VALUES(:bandit_id, :identifier_uuid, :identifier_type, :configuration, (current_timestamp at time zone 'UTC'), (current_timestamp at time zone 'UTC'))").bind("bandit_id", (Long)banditId.get())).bind("identifier_uuid", identifier.getUuid())).bind("identifier_type", (Object)identifier.descriptor().type())).bind("configuration", configuration)).execute();
                }
            }
            return null;
        }));
        this.bandits = null;
        return (Long)banditId.get();
    }

    public void updateBandit(UUID uuid, String description, String name) {
        this.nzyme.getDatabase().useHandle(handle -> handle.execute("UPDATE bandits SET name = ?, description = ?, updated_at = (current_timestamp at time zone 'UTC') WHERE bandit_uuid = ?", name, description, uuid));
        this.bandits = null;
    }

    public void removeBandit(UUID uuid) {
        this.nzyme.getDatabase().useHandle(handle -> handle.execute("DELETE FROM bandits WHERE bandit_uuid = ?", uuid));
        this.bandits = null;
    }

    public void registerIdentifier(Bandit bandit, BanditIdentifier identifier) {
        this.nzyme.getDatabase().useHandle(handle -> {
            String configuration;
            try {
                configuration = this.nzyme.getObjectMapper().writeValueAsString(identifier.configuration());
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
            ((Update)((Update)((Update)((Update)handle.createUpdate("INSERT INTO bandit_identifiers(bandit_id, identifier_uuid, identifier_type, configuration, created_at, updated_at) VALUES(:bandit_id, :identifier_uuid, :identifier_type, :configuration, (current_timestamp at time zone 'UTC'), (current_timestamp at time zone 'UTC'))").bind("bandit_id", bandit.databaseId())).bind("identifier_uuid", UUID.randomUUID())).bind("identifier_type", (Object)identifier.descriptor().type())).bind("configuration", configuration)).execute();
            ((Update)handle.createUpdate("UPDATE bandits SET updated_at = (current_timestamp at time zone 'UTC') WHERE bandit_uuid = :bandit_uuid").bind("bandit_uuid", bandit.uuid())).execute();
        });
        this.bandits = null;
    }

    public void removeIdentifier(UUID uuid) {
        this.nzyme.getDatabase().useHandle(handle -> handle.execute("DELETE FROM bandit_identifiers WHERE identifier_uuid = ?", uuid));
        this.bandits = null;
    }

    public boolean banditExists(UUID uuid) {
        long count;
        if (this.bandits != null) {
            for (Bandit bandit : this.bandits.values()) {
                if (!bandit.uuid().equals(uuid)) continue;
                return true;
            }
        }
        return (count = this.nzyme.getDatabase().withHandle(handle -> ((Query)handle.createQuery("SELECT COUNT(*) FROM bandits WHERE bandit_uuid = :uuid").bind("uuid", uuid)).mapTo(Long.class).first()).longValue()) > 0L;
    }

    public Map<UUID, Bandit> getBandits() {
        if (this.bandits != null) {
            return this.bandits;
        }
        List bandits = this.nzyme.getDatabase().withHandle(handle -> handle.createQuery("SELECT * FROM bandits ORDER BY updated_at DESC;").mapTo(Bandit.class).list());
        ImmutableMap.Builder<UUID, Bandit> result = new ImmutableMap.Builder<UUID, Bandit>();
        for (Bandit x2 : bandits) {
            List identifiers = this.nzyme.getDatabase().withHandle(handle -> ((Query)handle.createQuery("SELECT * FROM bandit_identifiers WHERE bandit_id = :bandit_id").bind("bandit_id", x2.databaseId())).mapTo(BanditIdentifier.class).list());
            Bandit bandit = Bandit.create(x2.databaseId(), x2.uuid(), x2.name(), x2.description(), x2.readOnly(), x2.createdAt(), x2.updatedAt(), identifiers);
            result.put(bandit.uuid(), bandit);
        }
        this.bandits = result.build();
        return this.bandits;
    }

    public List<Bandit> getBanditList() {
        return new ArrayList<Bandit>(this.getBandits().values());
    }

    @Override
    @Null
    public Bandit getCurrentlyTrackedBandit() {
        return null;
    }

    public Optional<Bandit> findBanditByDatabaseId(Long id2) {
        for (Bandit bandit : this.getBandits().values()) {
            if (bandit.databaseId() == null || !bandit.databaseId().equals(id2)) continue;
            return Optional.of(bandit);
        }
        return Optional.empty();
    }

    public Optional<Bandit> findBanditByUUID(UUID uuid) {
        for (Bandit bandit : this.getBandits().values()) {
            if (bandit.uuid() == null || !bandit.uuid().equals(uuid)) continue;
            return Optional.of(bandit);
        }
        return Optional.empty();
    }

    public void registerContact(Contact contact) {
        this.nzyme.getDatabase().useHandle(handle -> ((Update)((Update)((Update)((Update)handle.createUpdate("INSERT INTO contacts(contact_uuid, source_role, source_name, bandit_id, frame_count, first_seen, last_seen) VALUES(:contact_uuid, :source_role, :source_name, :bandit_id, 0, (current_timestamp at time zone 'UTC'), (current_timestamp at time zone 'UTC'))").bind("contact_uuid", contact.uuid())).bind("bandit_id", contact.bandit().databaseId())).bind("source_role", (Object)contact.sourceRole())).bind("source_name", contact.sourceName())).execute());
        this.contacts = null;
    }

    public void registerTrackerContactStatus(TrackerMessage.ContactStatus status) {
        Optional<Bandit> opt = this.findBanditByUUID(UUID.fromString(status.getUuid()));
        if (opt.isEmpty()) {
            LOG.info("Ignoring contact status for non-existent bandit [{}].", (Object)status.getUuid());
            return;
        }
        Bandit bandit = opt.get();
        if (this.banditHasActiveContactOnSource(bandit, status.getSource())) {
            this.updateContactFrames(bandit, status.getSource(), status.getFrames(), status.getRssi());
        } else {
            this.registerContact(Contact.create(UUID.randomUUID(), DateTime.now(), DateTime.now(), status.getFrames(), Role.TRACKER, status.getSource(), status.getRssi(), bandit.databaseId(), bandit));
        }
    }

    public boolean banditHasActiveContactOnSource(Bandit bandit, String sourceName) {
        long count = this.nzyme.getDatabase().withHandle(handle -> ((Query)((Query)handle.createQuery("SELECT COUNT(*) FROM contacts WHERE bandit_id = :bandit_id AND source_name = :source_name AND last_seen > (current_timestamp at time zone 'UTC' - interval '5 minutes')").bind("bandit_id", bandit.databaseId())).bind("source_name", sourceName)).mapTo(Long.class).first());
        return count > 0L;
    }

    public void registerContactFrame(Bandit bandit, String sourceName, int rssi, String bssid, Optional<String> ssid) {
        UUID contactUUID = this.nzyme.getDatabase().withHandle(handle -> ((Query)((Query)((Query)handle.createQuery("SELECT contact_uuid FROM contacts WHERE bandit_id = :bandit_id AND source_name = :source_name AND last_seen > (current_timestamp at time zone 'UTC' - interval '5 minutes')").bind("source_name", sourceName)).bind("last_signal", rssi)).bind("bandit_id", bandit.databaseId())).mapTo(UUID.class).first());
        if (contactUUID != null) {
            this.nzyme.getDatabase().useHandle(handle -> ((Update)((Update)handle.createUpdate("UPDATE contacts SET frame_count = frame_count+1, last_seen = (current_timestamp at time zone 'UTC'), last_signal = :last_signal WHERE contact_uuid = :contact_uuid").bind("last_signal", rssi)).bind("contact_uuid", contactUUID)).execute());
            this.contactRecorder.recordFrame(contactUUID, rssi, bssid, ssid);
            this.contacts = null;
        }
    }

    public Optional<List<ContactRecordAggregation>> findRecordValuesOfContact(UUID contactUUID, ContactRecorder.RECORD_TYPE recordType) {
        List values2 = this.nzyme.getDatabase().withHandle(handle -> ((Query)((Query)handle.createQuery("SELECT DISTINCT(record_value) AS record_value, SUM(frame_count) AS frame_count FROM contact_records WHERE contact_uuid = :contact_uuid AND record_type = :record_type GROUP BY record_value ORDER BY frame_count DESC").bind("contact_uuid", contactUUID)).bind("record_type", (Object)recordType)).mapTo(ContactRecordAggregation.class).list());
        if (values2 == null || values2.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(values2);
    }

    public Optional<Map<String, List<ContactRecorderHistogramEntry>>> findRecordingHistogramsOfContact(UUID contactUUID, List<String> values2, ContactRecorder.RECORD_TYPE type) {
        if (values2.isEmpty()) {
            return Optional.empty();
        }
        HashMap<String, List> result = Maps.newHashMap();
        for (String value : values2) {
            List entries = this.nzyme.getDatabase().withHandle(handle -> ((Query)((Query)((Query)((Query)handle.createQuery("SELECT frame_count, rssi_average AS signal_strength, created_at FROM contact_records WHERE contact_uuid = :contact_uuid AND record_type = :record_type AND record_value = :value ORDER BY created_at DESC LIMIT :limit").bind("contact_uuid", contactUUID)).bind("record_type", (Object)type)).bind("value", value)).bind("limit", 1440)).mapTo(ContactRecorderHistogramEntry.class).list());
            result.put(value, entries);
        }
        return Optional.of(result);
    }

    public void updateContactFrames(Bandit bandit, String sourceName, long frameCount, int rssi) {
        this.nzyme.getDatabase().useHandle(handle -> ((Update)((Update)((Update)((Update)handle.createUpdate("UPDATE contacts SET frame_count = :frame_count, last_seen = (current_timestamp at time zone 'UTC'), last_signal = :last_signal WHERE bandit_id = :bandit_id AND source_name = :source_name AND last_seen > (current_timestamp at time zone 'UTC' - interval '5 minutes')").bind("frame_count", frameCount)).bind("last_signal", rssi)).bind("source_name", sourceName)).bind("bandit_id", bandit.databaseId())).execute());
        this.contacts = null;
    }

    public Map<UUID, Contact> findContacts() {
        return this.findContacts(Integer.MAX_VALUE, 0);
    }

    public Map<UUID, Contact> findContacts(int limit, int offset) {
        List contacts = this.nzyme.getDatabase().withHandle(handle -> ((Query)((Query)handle.createQuery("SELECT * FROM contacts ORDER BY last_seen DESC LIMIT :limit OFFSET :offset").bind("limit", limit)).bind("offset", offset)).mapTo(Contact.class).list());
        ImmutableMap.Builder<UUID, Contact> result = new ImmutableMap.Builder<UUID, Contact>();
        for (Contact x2 : contacts) {
            result.put(x2.uuid(), Contact.create(x2.uuid(), x2.firstSeen(), x2.lastSeen(), x2.frameCount(), x2.sourceRole(), x2.sourceName(), x2.lastSignal(), x2.banditId(), this.findBanditByDatabaseId(x2.banditId()).orElse(null)));
        }
        this.contacts = result.build();
        return this.contacts;
    }

    public List<Contact> findContactsOfBandit(Bandit bandit) {
        return this.nzyme.getDatabase().withHandle(handle -> ((Query)handle.createQuery("SELECT * FROM contacts WHERE bandit_id = :bandit_id ORDER BY last_seen DESC LIMIT 50").bind("bandit_id", bandit.databaseId())).mapTo(Contact.class).list());
    }

    public Optional<Contact> findContactOfBandit(Bandit bandit, UUID contactUUID) {
        Contact contact = this.nzyme.getDatabase().withHandle(handle -> ((Query)((Query)handle.createQuery("SELECT * FROM contacts WHERE bandit_id = :bandit_id AND contact_uuid = :contact_uuid").bind("bandit_id", bandit.databaseId())).bind("contact_uuid", contactUUID)).mapTo(Contact.class).first());
        if (contact == null) {
            return Optional.empty();
        }
        return Optional.of(contact);
    }

    public List<Contact> findContactsOfTracker(Tracker tracker) {
        return this.nzyme.getDatabase().withHandle(handle -> ((Query)handle.createQuery("SELECT * FROM contacts WHERE source_name = :source_name ORDER BY last_seen DESC LIMIT 50").bind("source_name", tracker.getName())).mapTo(Contact.class).list());
    }

    @Override
    public void identify(Dot11Frame frame) {
        for (Map.Entry<UUID, Bandit> x2 : this.getBandits().entrySet()) {
            Optional<ContactIdentifierEngine.ContactIdentification> result;
            Bandit bandit = x2.getValue();
            if (bandit.identifiers() == null || bandit.identifiers().isEmpty() || !(result = this.identifierEngine.identify(frame, bandit)).isPresent()) continue;
            if (!this.banditHasActiveContactOnSource(bandit, this.nzyme.getNodeID())) {
                LOG.debug("New contact for bandit [{}].", (Object)bandit);
                DateTime now = DateTime.now();
                this.registerContact(Contact.create(UUID.randomUUID(), now, now, 1L, Role.LEADER, this.nzyme.getNodeID(), frame.meta().getAntennaSignal(), null, bandit));
            }
            LOG.debug("Registering frame for existing bandit [{}]", (Object)bandit);
            this.registerContactFrame(bandit, this.nzyme.getNodeID(), frame.meta().getAntennaSignal(), result.get().bssid(), result.get().ssid());
            if (!this.nzyme.getConfiguration().dot11Alerts().contains((Object)Alert.TYPE_WIDE.BANDIT_CONTACT)) continue;
            this.nzyme.getAlertsService().handle(BanditContactAlert.create(DateTime.now(), bandit.name(), bandit.uuid().toString(), result.get().ssid(), 1L));
        }
    }
}

