/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.bandits.database;

import horse.wtf.nzyme.bandits.engine.ContactRecord;
import horse.wtf.nzyme.bandits.engine.ContactRecorder;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.StatementContext;
import org.joda.time.DateTime;

public class ContactRecordMapper
implements RowMapper<ContactRecord> {
    @Override
    public ContactRecord map(ResultSet rs, StatementContext ctx) throws SQLException {
        ContactRecorder.RECORD_TYPE recordType;
        try {
            recordType = ContactRecorder.RECORD_TYPE.valueOf(rs.getString("record_type"));
        }
        catch (IllegalArgumentException e2) {
            throw new SQLException("Cannot serialize contact record of unknown type.", e2);
        }
        return ContactRecord.create(UUID.fromString(rs.getString("contact_uuid")), recordType, rs.getString("record_value"), rs.getLong("frame_count"), rs.getDouble("rssi_average"), rs.getDouble("rssi_stddev"), new DateTime(rs.getTimestamp("created_at")));
    }
}

