/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.bandits.database;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import horse.wtf.nzyme.bandits.identifiers.BanditIdentifier;
import horse.wtf.nzyme.bandits.identifiers.BanditIdentifierFactory;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.UUID;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.StatementContext;

public class BanditIdentifierMapper
implements RowMapper<BanditIdentifier> {
    private final ObjectMapper om = new ObjectMapper();

    @Override
    public BanditIdentifier map(ResultSet rs, StatementContext ctx) throws SQLException {
        Map<String, Object> config;
        BanditIdentifier.TYPE type;
        try {
            type = BanditIdentifier.TYPE.valueOf(rs.getString("identifier_type"));
        }
        catch (IllegalArgumentException e2) {
            throw new SQLException("Cannot serialize bandit identifier of unknown type.", e2);
        }
        try {
            config = this.om.readValue(rs.getString("configuration"), new TypeReference<Map<String, Object>>(){});
        }
        catch (IOException e3) {
            throw new SQLException("Cannot serialize bandit identifier configuration.", e3);
        }
        try {
            return BanditIdentifierFactory.create(type, config, rs.getLong("id"), UUID.fromString(rs.getString("identifier_uuid")));
        }
        catch (BanditIdentifierFactory.NoSerializerException e4) {
            throw new SQLException("No serializer configured for bandit identifier of type [" + type + "].");
        }
        catch (BanditIdentifierFactory.MappingException e5) {
            throw new SQLException("Could not map configuration to bandit identifier..");
        }
    }
}

