/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.alerts.service.callbacks;

import com.google.auto.value.AutoValue;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.typesafe.config.Config;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import horse.wtf.nzyme.alerts.Alert;
import horse.wtf.nzyme.alerts.service.callbacks.AlertCallback;
import horse.wtf.nzyme.alerts.service.callbacks.AutoValue_EmailCallback_Configuration;
import horse.wtf.nzyme.configuration.ConfigurationValidator;
import horse.wtf.nzyme.configuration.IncompleteConfigurationException;
import horse.wtf.nzyme.configuration.InvalidConfigurationException;
import horse.wtf.nzyme.util.Tools;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.http.client.utils.URIBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.simplejavamail.api.email.Email;
import org.simplejavamail.api.email.Recipient;
import org.simplejavamail.api.mailer.Mailer;
import org.simplejavamail.api.mailer.config.TransportStrategy;
import org.simplejavamail.email.EmailBuilder;
import org.simplejavamail.mailer.MailerBuilder;
import org.simplejavamail.mailer.internal.MailerRegularBuilderImpl;

public class EmailCallback
implements AlertCallback {
    private static final Logger LOG = LogManager.getLogger(EmailCallback.class);
    private final Configuration configuration;
    private final Mailer mailer;
    private final freemarker.template.Configuration templateConfig;
    private static final String WHERE = "alerting.callbacks.[email]";

    public EmailCallback(Configuration configuration) {
        this.configuration = configuration;
        this.mailer = ((MailerRegularBuilderImpl)MailerBuilder.withSMTPServer(configuration.host(), configuration.port(), configuration.username(), configuration.password()).withTransportStrategy(configuration.transportStrategy()).clearEmailAddressCriteria()).buildMailer();
        this.templateConfig = new freemarker.template.Configuration(freemarker.template.Configuration.VERSION_2_3_30);
        this.templateConfig.setClassForTemplateLoading(this.getClass(), "/");
        this.templateConfig.setDefaultEncoding("UTF-8");
        this.templateConfig.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        this.templateConfig.setLogTemplateExceptions(false);
        this.templateConfig.setWrapUncheckedExceptions(true);
        this.templateConfig.setFallbackOnNullLoopVariable(false);
    }

    @Override
    public void call(Alert alert) {
        LOG.info("Sending alert email.");
        try {
            Email email = EmailBuilder.startingBlank().to(this.configuration.recipients()).from(this.configuration.from()).withSubject(this.configuration.subjectPrefix() + " " + this.buildSubject(alert)).withPlainText(this.buildPlainTextBody(alert)).withHTMLText(this.buildHTMLTextBody(alert)).withEmbeddedImage("nzyme_logo", this.loadLogoFile(), "image/png").buildEmail();
            this.mailer.sendMail(email);
        }
        catch (Exception e2) {
            LOG.error("Could not send Email.", (Throwable)e2);
        }
    }

    private String buildSubject(Alert alert) {
        return "Alert [" + alert.getSubsystem() + "/" + alert.getType().toString() + "]";
    }

    private String buildPlainTextBody(Alert alert) throws URISyntaxException {
        StringBuilder sb = new StringBuilder();
        sb.append("ALERT: " + alert.getMessage()).append("\n\n").append(alert.getDescription()).append("\n\n").append("Link: ").append(this.buildHTTPURI(alert)).append("\n");
        for (Map.Entry<String, Object> field : alert.getFields().entrySet()) {
            sb.append("\n").append(field.getKey()).append(": ").append(field.getValue());
        }
        return sb.toString();
    }

    @Nullable
    private String buildHTMLTextBody(Alert alert) throws IOException {
        try {
            HashMap<String, Object> parameters = Maps.newHashMap();
            parameters.put("title", "nzyme Alert");
            parameters.put("alert_summary", alert.getMessage());
            parameters.put("alert_description", alert.getDescription());
            parameters.put("details_link", this.buildHTTPURI(alert));
            parameters.put("fields", alert.getFields());
            StringWriter out = new StringWriter();
            Template template = this.templateConfig.getTemplate("email/template_basic.ftl");
            template.process(parameters, out);
            return out.toString();
        }
        catch (Exception e2) {
            LOG.error("Could not build HTML text body.", (Throwable)e2);
            return null;
        }
    }

    private byte[] loadLogoFile() throws IOException {
        InputStream resource = this.getClass().getClassLoader().getResourceAsStream("email/nzyme.png");
        if (resource == null) {
            throw new RuntimeException("Couldn't load nzyme logo file.");
        }
        return resource.readAllBytes();
    }

    private URI buildHTTPURI(Alert alert) throws URISyntaxException {
        return new URIBuilder(this.configuration.httpExternalURI()).setPath("/alerts/show/" + alert.getUUID()).build();
    }

    public static Configuration parseConfiguration(Config c2, String httpExternalUri) throws InvalidConfigurationException, IncompleteConfigurationException {
        TransportStrategy transportStrategy;
        ConfigurationValidator.expect(c2, "transport_strategy", WHERE, String.class);
        ConfigurationValidator.expect(c2, "host", WHERE, String.class);
        ConfigurationValidator.expect(c2, "port", WHERE, Integer.class);
        ConfigurationValidator.expect(c2, "username", WHERE, String.class);
        ConfigurationValidator.expect(c2, "password", WHERE, String.class);
        ConfigurationValidator.expect(c2, "recipients", WHERE, List.class);
        ConfigurationValidator.expect(c2, "from", WHERE, String.class);
        ConfigurationValidator.expect(c2, "subject_prefix", WHERE, String.class);
        try {
            transportStrategy = TransportStrategy.valueOf(c2.getString("transport_strategy"));
        }
        catch (IllegalArgumentException e2) {
            throw new InvalidConfigurationException("Invalid SMTP transport strategy.", e2);
        }
        ArrayList<Recipient> recipients = Lists.newArrayList();
        for (String rec : c2.getStringList("recipients")) {
            recipients.add(Tools.parseEmailAddress(rec));
        }
        return Configuration.create(transportStrategy, c2.getString("host"), c2.getInt("port"), c2.getString("username"), c2.getString("password"), recipients, Tools.parseEmailAddress(c2.getString("from")), c2.getString("subject_prefix"), httpExternalUri);
    }

    @AutoValue
    public static abstract class Configuration {
        public abstract TransportStrategy transportStrategy();

        public abstract String host();

        public abstract int port();

        public abstract String username();

        public abstract String password();

        public abstract List<Recipient> recipients();

        public abstract Recipient from();

        public abstract String subjectPrefix();

        public abstract String httpExternalURI();

        public static Configuration create(TransportStrategy transportStrategy, String host, int port, String username, String password, List<Recipient> recipients, Recipient from, String subjectPrefix, String httpExternalURI) {
            return Configuration.builder().transportStrategy(transportStrategy).host(host).port(port).username(username).password(password).recipients(recipients).from(from).subjectPrefix(subjectPrefix).httpExternalURI(httpExternalURI).build();
        }

        public static Builder builder() {
            return new AutoValue_EmailCallback_Configuration.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder transportStrategy(TransportStrategy var1);

            public abstract Builder host(String var1);

            public abstract Builder port(int var1);

            public abstract Builder username(String var1);

            public abstract Builder password(String var1);

            public abstract Builder recipients(List<Recipient> var1);

            public abstract Builder from(Recipient var1);

            public abstract Builder subjectPrefix(String var1);

            public abstract Builder httpExternalURI(String var1);

            public abstract Configuration build();
        }
    }
}

