/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.alerts.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import horse.wtf.nzyme.NzymeLeader;
import horse.wtf.nzyme.alerts.Alert;
import horse.wtf.nzyme.alerts.service.AlertDatabaseEntry;
import horse.wtf.nzyme.alerts.service.callbacks.AlertCallback;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdbi.v3.core.statement.Query;

public class AlertsService {
    public static final int EXPIRY_MINUTES = 10;
    private static final Logger LOG = LogManager.getLogger(AlertsService.class);
    private static final String ALERTS_QUERY = "SELECT * FROM alerts ORDER BY last_seen DESC LIMIT :limit OFFSET :offset";
    private static final String ALERTS_24_HOURS_QUERY = "SELECT * FROM alerts WHERE last_seen >(current_timestamp at time zone 'UTC' - interval '24 hours') ORDER BY last_seen DESC LIMIT :limit";
    private static final String ACTIVE_ALERTS_QUERY = "SELECT * FROM alerts WHERE last_seen >(current_timestamp at time zone 'UTC' - interval '10 minutes') ORDER BY last_seen DESC";
    private final NzymeLeader nzyme;
    private final List<AlertCallback> callbacks;

    public AlertsService(NzymeLeader nzyme) {
        this.nzyme = nzyme;
        this.callbacks = Lists.newArrayList();
    }

    public void handle(Alert alert) {
        for (Map.Entry<UUID, Alert> entry : this.findActiveAlerts().entrySet()) {
            Alert activeAlert = entry.getValue();
            if (!activeAlert.sameAs(alert)) continue;
            this.updateLastSeenAndFrameCount(activeAlert, 1);
            return;
        }
        UUID uuid = UUID.randomUUID();
        alert.setUUID(uuid);
        this.nzyme.notifyUplinksOfAlert(alert);
        for (AlertCallback callback : this.callbacks) {
            LOG.info("Triggering alert callback type [{}]", (Object)callback.getClass().getCanonicalName());
            callback.call(alert);
        }
        this.writeAlert(alert);
    }

    public void registerCallbacks(List<AlertCallback> callbacks) {
        for (AlertCallback callback : callbacks) {
            this.registerCallback(callback);
        }
    }

    public void registerCallback(AlertCallback callback) {
        LOG.info("Registering alert callback of type [{}].", (Object)callback.getClass().getCanonicalName());
        this.callbacks.add(callback);
    }

    public Alert findAlert(UUID id2) throws IOException {
        return Alert.serializeFromDatabase(this.nzyme.getDatabase().withHandle(handle -> ((Query)handle.createQuery("SELECT * FROM alerts WHERE alert_uuid = :uuid").bind("uuid", id2)).mapTo(AlertDatabaseEntry.class).one()));
    }

    public Map<UUID, Alert> findAllAlerts(int limit, int offset) {
        return this.buildAlertsMap(this.nzyme.getDatabase().withHandle(handle -> ((Query)((Query)handle.createQuery(ALERTS_QUERY).bind("limit", limit)).bind("offset", offset)).mapTo(AlertDatabaseEntry.class).list()));
    }

    public Map<UUID, Alert> findAllAlertsSince24HoursAgo(int limit) {
        return this.buildAlertsMap(this.nzyme.getDatabase().withHandle(handle -> ((Query)handle.createQuery(ALERTS_24_HOURS_QUERY).bind("limit", limit)).mapTo(AlertDatabaseEntry.class).list()));
    }

    public Map<UUID, Alert> findActiveAlerts() {
        return this.buildAlertsMap(this.nzyme.getDatabase().withHandle(handle -> handle.createQuery(ACTIVE_ALERTS_QUERY).mapTo(AlertDatabaseEntry.class).list()));
    }

    public long countAllAlerts() {
        return this.nzyme.getDatabase().withHandle(handle -> handle.createQuery("SELECT COUNT(*) FROM alerts;").mapTo(Long.class).one());
    }

    private Map<UUID, Alert> buildAlertsMap(List<AlertDatabaseEntry> alertEntries) {
        ImmutableMap.Builder<UUID, Alert> alerts = new ImmutableMap.Builder<UUID, Alert>();
        for (AlertDatabaseEntry db2 : alertEntries) {
            try {
                alerts.put(db2.uuid(), Alert.serializeFromDatabase(db2));
            }
            catch (Exception e2) {
                LOG.error("Could not serialize alert from database.", (Throwable)e2);
            }
        }
        return alerts.build();
    }

    private void writeAlert(Alert alert) {
        String fields;
        try {
            fields = this.nzyme.getObjectMapper().writeValueAsString(alert.getFields());
        }
        catch (JsonProcessingException e2) {
            throw new RuntimeException("Couldn't serialize alert fields.", e2);
        }
        this.nzyme.getDatabase().useHandle(handle -> handle.execute("INSERT INTO alerts(alert_uuid, alert_type, subsystem, fields, first_seen, last_seen, frame_count, use_frame_count) VALUES(?, ?, ?, ?, (current_timestamp at time zone 'UTC'), (current_timestamp at time zone 'UTC'), 1, ?)", new Object[]{alert.getUUID(), alert.getType(), alert.getSubsystem(), fields, alert.isUseFrameCount()}));
    }

    private void updateLastSeenAndFrameCount(Alert alert, int frameIncrement) {
        this.nzyme.getDatabase().useHandle(handle -> handle.execute("UPDATE alerts SET last_seen = (current_timestamp at time zone 'UTC'), frame_count = frame_count+? WHERE alert_uuid = ?", frameIncrement, alert.getUUID()));
    }
}

