/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.alerts;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import horse.wtf.nzyme.Subsystem;
import horse.wtf.nzyme.alerts.Alert;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.joda.time.DateTime;

public class UnexpectedBSSIDProbeRespAlert
extends Alert {
    private static final String DESCRIPTION = "A station with an unexpected BSSID (hardware address) is replying to devices that are looking for one of our networks (probing). This could be a rogue access point trying to lure users to connect to it by making it look like a legitimate access point of a wireless network that users trust. Note that sophisticated attackers will likely not cause this kind of alert because they would act like a legitimate access point by sending frames with a spoofed BSSID.";
    private static final String DOC_LINK = "guidance-UNEXPECTED_PROBERESP_BSSID";
    private static final List<String> FALSE_POSITIVES = new ArrayList<String>(){
        {
            this.add("A new access point was installed and the nzyme configuration has not been updated yet.");
        }
    };

    private UnexpectedBSSIDProbeRespAlert(DateTime timestamp, Subsystem subsystem, Map<String, Object> fields, long frameCount) {
        super(timestamp, subsystem, fields, DESCRIPTION, DOC_LINK, FALSE_POSITIVES, true, frameCount);
    }

    @Override
    public String getMessage() {
        return "SSID [" + this.getSSID() + "] was advertised with probe response frame by unexpected BSSID [" + this.getBSSID() + "] for [" + this.getDestination() + "]";
    }

    @Override
    public Alert.TYPE getType() {
        return Alert.TYPE.UNEXPECTED_BSSID_PROBERESP;
    }

    public String getSSID() {
        return (String)this.getFields().get("ssid");
    }

    public String getBSSID() {
        return (String)this.getFields().get("bssid");
    }

    public String getDestination() {
        return (String)this.getFields().get("destination");
    }

    @Override
    public boolean sameAs(Alert alert) {
        if (!(alert instanceof UnexpectedBSSIDProbeRespAlert)) {
            return false;
        }
        UnexpectedBSSIDProbeRespAlert a2 = (UnexpectedBSSIDProbeRespAlert)alert;
        return a2.getSSID().equals(this.getSSID()) && a2.getBSSID().equals(this.getBSSID());
    }

    public static UnexpectedBSSIDProbeRespAlert create(DateTime firstSeen, @NotNull String ssid, String bssid, String destination, int channel, int frequency, int antennaSignal, long frameCount) {
        if (Strings.isNullOrEmpty(ssid)) {
            throw new IllegalArgumentException("This alert cannot be raised for hidden/broadcast SSIDs.");
        }
        ImmutableMap.Builder<String, Object> fields = new ImmutableMap.Builder<String, Object>();
        fields.put("ssid", ssid);
        fields.put("bssid", bssid.toLowerCase());
        fields.put("destination", destination.toLowerCase());
        fields.put("channel", channel);
        fields.put("frequency", frequency);
        fields.put("antenna_signal", antennaSignal);
        return new UnexpectedBSSIDProbeRespAlert(firstSeen, Subsystem.DOT_11, fields.build(), frameCount);
    }
}

