/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.alerts;

import com.google.common.collect.ImmutableMap;
import horse.wtf.nzyme.Subsystem;
import horse.wtf.nzyme.alerts.Alert;
import horse.wtf.nzyme.dot11.interceptors.misc.PwnagotchiAdvertisement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;

public class PwnagotchiAdvertisementAlert
extends Alert {
    private static final String DESCRIPTION = "A pwnagotchi beacon advertisement frame was detected. The pwnagotchi is a popular and mostly automated WiFi attack platform. It uses a parasitic protocol embedded in 802.11 beacon frames to advertise it's own existence to other pwnagotchis in range and nzyme is able to detect those advertisement frames.";
    private static final String DOC_LINK = "guidance-PWNAGOTCHI_ADVERTISEMENT";
    private static final List<String> FALSE_POSITIVES = new ArrayList<String>(){
        {
            this.add("No known false positives.");
        }
    };

    private PwnagotchiAdvertisementAlert(DateTime timestamp, Subsystem subsystem, Map<String, Object> fields, long frameCount) {
        super(timestamp, subsystem, fields, DESCRIPTION, DOC_LINK, FALSE_POSITIVES, true, frameCount);
    }

    @Override
    public String getMessage() {
        return "Pwnagotchi [" + this.getName() + "] with identity [" + this.getIdentity() + "] and version [" + this.getVersion() + "] detected. Uptime [" + this.getUptime() + "].";
    }

    @Override
    public Alert.TYPE getType() {
        return Alert.TYPE.PWNAGOTCHI_ADVERTISEMENT;
    }

    public String getName() {
        return (String)this.getFields().get("name");
    }

    public String getVersion() {
        return (String)this.getFields().get("version");
    }

    public String getIdentity() {
        return (String)this.getFields().get("identity");
    }

    public double getUptime() {
        return (Double)this.getFields().get("uptime");
    }

    @Override
    public boolean sameAs(Alert alert) {
        if (!(alert instanceof PwnagotchiAdvertisementAlert)) {
            return false;
        }
        PwnagotchiAdvertisementAlert a2 = (PwnagotchiAdvertisementAlert)alert;
        return a2.getIdentity().equals(this.getIdentity());
    }

    public static PwnagotchiAdvertisementAlert create(DateTime firstSeen, PwnagotchiAdvertisement advertisement, int channel, int frequency, int antennaSignal, long frameCount) {
        ImmutableMap.Builder<String, Object> fields = new ImmutableMap.Builder<String, Object>();
        fields.put("name", advertisement.name() == null ? "unknown" : advertisement.name());
        fields.put("version", advertisement.version() == null ? "0" : advertisement.version());
        fields.put("identity", advertisement.identity() == null ? "unknown" : advertisement.identity());
        fields.put("uptime", advertisement.uptime() == null ? -1.0 : advertisement.uptime());
        fields.put("pwnd_this_run", advertisement.pwndThisRun() == null ? -1 : advertisement.pwndThisRun());
        fields.put("pwnd_total", advertisement.pwndTotal() == null ? -1 : advertisement.pwndTotal());
        fields.put("channel", channel);
        fields.put("frequency", frequency);
        fields.put("antenna_signal", antennaSignal);
        return new PwnagotchiAdvertisementAlert(firstSeen, Subsystem.DOT_11, fields.build(), frameCount);
    }
}

