/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.alerts;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import horse.wtf.nzyme.Subsystem;
import horse.wtf.nzyme.alerts.Alert;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.joda.time.DateTime;

public class BeaconRateAnomalyAlert
extends Alert {
    private static final String DESCRIPTION = "One of our networks is sending beacon frames in a higher frequency than expected. This could indicate that an attacker is spoofing one of our access points and that their additional beacon frames are leading to this increase.";
    private static final String DOC_LINK = "guidance-BEACON_RATE";
    private static final List<String> FALSE_POSITIVES = new ArrayList<String>(){
        {
            this.add("The beacon frequency threshold is a manual nzyme config and might be set to a wrong value.");
            this.add("A legitimate access point might have decided to increase the beacon rate. Try to adapt the beacon frequency threshold accordingly.");
        }
    };

    private BeaconRateAnomalyAlert(DateTime timestamp, Subsystem subsystem, Map<String, Object> fields) {
        super(timestamp, subsystem, fields, DESCRIPTION, DOC_LINK, FALSE_POSITIVES, false, -1L);
    }

    @Override
    public String getMessage() {
        return "Beacon rate anomaly detected for our SSID [" + this.getSSID() + "] on [" + this.getBSSID() + "]. Rate <" + this.getBeaconRate() + "> is over threshold <" + this.getBeaconRateThreshold() + ">.";
    }

    @Override
    public Alert.TYPE getType() {
        return Alert.TYPE.BEACON_RATE_ANOMALY;
    }

    public String getSSID() {
        return (String)this.getFields().get("ssid");
    }

    public String getBSSID() {
        return (String)this.getFields().get("bssid");
    }

    public double getBeaconRate() {
        return (Double)this.getFields().get("beacon_rate");
    }

    public int getBeaconRateThreshold() {
        return (Integer)this.getFields().get("beacon_rate_threshold");
    }

    @Override
    public boolean sameAs(Alert alert) {
        if (!(alert instanceof BeaconRateAnomalyAlert)) {
            return false;
        }
        BeaconRateAnomalyAlert a2 = (BeaconRateAnomalyAlert)alert;
        return a2.getSSID().equals(this.getSSID()) && a2.getBSSID().equals(this.getBSSID());
    }

    public static BeaconRateAnomalyAlert create(DateTime firstSeen, @NotNull String ssid, String bssid, double beaconRate, int beaconRateThreshold) {
        if (Strings.isNullOrEmpty(ssid)) {
            throw new IllegalArgumentException("This alert cannot be raised for hidden/broadcast SSIDs.");
        }
        ImmutableMap.Builder<String, Object> fields = new ImmutableMap.Builder<String, Object>();
        fields.put("ssid", ssid);
        fields.put("bssid", bssid.toLowerCase());
        fields.put("beacon_rate", beaconRate);
        fields.put("beacon_rate_threshold", beaconRateThreshold);
        return new BeaconRateAnomalyAlert(firstSeen, Subsystem.DOT_11, fields.build());
    }
}

