/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.xml;

import freemarker.ext.xml.Navigator;
import freemarker.template.TemplateModelException;
import freemarker.template.utility.StringUtil;
import java.io.StringWriter;
import java.util.List;
import org.jaxen.Context;
import org.jaxen.NamespaceContext;
import org.jaxen.dom.DOMXPath;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class _DomNavigator
extends Navigator {
    @Override
    void getAsString(Object node, StringWriter sw) {
        this.outputContent((Node)node, sw);
    }

    private void outputContent(Node n2, StringWriter buf) {
        switch (n2.getNodeType()) {
            case 2: {
                buf.append(' ').append(this.getQualifiedName(n2)).append("=\"").append(StringUtil.XMLEncNA(n2.getNodeValue())).append('\"');
                break;
            }
            case 4: {
                buf.append("<![CDATA[").append(n2.getNodeValue()).append("]]>");
                break;
            }
            case 8: {
                buf.append("<!--").append(n2.getNodeValue()).append("-->");
                break;
            }
            case 9: {
                this.outputContent(n2.getChildNodes(), buf);
                break;
            }
            case 10: {
                buf.append("<!DOCTYPE ").append(n2.getNodeName());
                DocumentType dt2 = (DocumentType)n2;
                if (dt2.getPublicId() != null) {
                    buf.append(" PUBLIC \"").append(dt2.getPublicId()).append('\"');
                }
                if (dt2.getSystemId() != null) {
                    buf.append('\"').append(dt2.getSystemId()).append('\"');
                }
                if (dt2.getInternalSubset() != null) {
                    buf.append(" [").append(dt2.getInternalSubset()).append(']');
                }
                buf.append('>');
                break;
            }
            case 1: {
                buf.append('<').append(this.getQualifiedName(n2));
                this.outputContent(n2.getAttributes(), buf);
                buf.append('>');
                this.outputContent(n2.getChildNodes(), buf);
                buf.append("</").append(this.getQualifiedName(n2)).append('>');
                break;
            }
            case 6: {
                this.outputContent(n2.getChildNodes(), buf);
                break;
            }
            case 5: {
                buf.append('&').append(n2.getNodeName()).append(';');
                break;
            }
            case 7: {
                buf.append("<?").append(n2.getNodeName()).append(' ').append(n2.getNodeValue()).append("?>");
                break;
            }
            case 3: {
                buf.append(StringUtil.XMLEncNQG(n2.getNodeValue()));
            }
        }
    }

    private void outputContent(NodeList nodes, StringWriter buf) {
        for (int i2 = 0; i2 < nodes.getLength(); ++i2) {
            this.outputContent(nodes.item(i2), buf);
        }
    }

    private void outputContent(NamedNodeMap nodes, StringWriter buf) {
        for (int i2 = 0; i2 < nodes.getLength(); ++i2) {
            this.outputContent(nodes.item(i2), buf);
        }
    }

    @Override
    void getChildren(Object node, String localName, String namespaceUri, List result) {
        if ("".equals(namespaceUri)) {
            namespaceUri = null;
        }
        NodeList children = ((Node)node).getChildNodes();
        for (int i2 = 0; i2 < children.getLength(); ++i2) {
            Node subnode = children.item(i2);
            if (subnode.getNodeType() != 1 && subnode.getNodeType() != 3 || localName != null && (!this.equal(subnode.getNodeName(), localName) || !this.equal(subnode.getNamespaceURI(), namespaceUri))) continue;
            result.add(subnode);
        }
    }

    @Override
    void getAttributes(Object node, String localName, String namespaceUri, List result) {
        if (node instanceof Element) {
            Element e2 = (Element)node;
            if (localName == null) {
                NamedNodeMap atts = e2.getAttributes();
                for (int i2 = 0; i2 < atts.getLength(); ++i2) {
                    result.add(atts.item(i2));
                }
            } else {
                Attr attr;
                if ("".equals(namespaceUri)) {
                    namespaceUri = null;
                }
                if ((attr = e2.getAttributeNodeNS(namespaceUri, localName)) != null) {
                    result.add(attr);
                }
            }
        } else if (node instanceof ProcessingInstruction) {
            ProcessingInstruction pi = (ProcessingInstruction)node;
            if ("target".equals(localName)) {
                result.add(this.createAttribute(pi, "target", pi.getTarget()));
            } else if ("data".equals(localName)) {
                result.add(this.createAttribute(pi, "data", pi.getData()));
            }
        } else if (node instanceof DocumentType) {
            DocumentType doctype = (DocumentType)node;
            if ("publicId".equals(localName)) {
                result.add(this.createAttribute(doctype, "publicId", doctype.getPublicId()));
            } else if ("systemId".equals(localName)) {
                result.add(this.createAttribute(doctype, "systemId", doctype.getSystemId()));
            } else if ("elementName".equals(localName)) {
                result.add(this.createAttribute(doctype, "elementName", doctype.getNodeName()));
            }
        }
    }

    private Attr createAttribute(Node node, String name, String value) {
        Attr attr = node.getOwnerDocument().createAttribute(name);
        attr.setNodeValue(value);
        return attr;
    }

    @Override
    void getDescendants(Object node, List result) {
        NodeList children = ((Node)node).getChildNodes();
        for (int i2 = 0; i2 < children.getLength(); ++i2) {
            Node subnode = children.item(i2);
            if (subnode.getNodeType() != 1) continue;
            result.add(subnode);
            this.getDescendants(subnode, result);
        }
    }

    @Override
    Object getParent(Object node) {
        return ((Node)node).getParentNode();
    }

    @Override
    Object getDocument(Object node) {
        return ((Node)node).getOwnerDocument();
    }

    @Override
    Object getDocumentType(Object node) {
        return node instanceof Document ? ((Document)node).getDoctype() : null;
    }

    @Override
    void getContent(Object node, List result) {
        NodeList children = ((Node)node).getChildNodes();
        for (int i2 = 0; i2 < children.getLength(); ++i2) {
            result.add(children.item(i2));
        }
    }

    @Override
    String getText(Object node) {
        StringBuilder buf = new StringBuilder();
        if (node instanceof Element) {
            NodeList children = ((Node)node).getChildNodes();
            for (int i2 = 0; i2 < children.getLength(); ++i2) {
                Node child = children.item(i2);
                if (!(child instanceof Text)) continue;
                buf.append(child.getNodeValue());
            }
            return buf.toString();
        }
        return ((Node)node).getNodeValue();
    }

    @Override
    String getLocalName(Object node) {
        return ((Node)node).getNodeName();
    }

    @Override
    String getNamespacePrefix(Object node) {
        return ((Node)node).getPrefix();
    }

    @Override
    String getNamespaceUri(Object node) {
        return ((Node)node).getNamespaceURI();
    }

    @Override
    String getType(Object node) {
        switch (((Node)node).getNodeType()) {
            case 2: {
                return "attribute";
            }
            case 4: {
                return "cdata";
            }
            case 8: {
                return "comment";
            }
            case 9: {
                return "document";
            }
            case 10: {
                return "documentType";
            }
            case 1: {
                return "element";
            }
            case 6: {
                return "entity";
            }
            case 5: {
                return "entityReference";
            }
            case 7: {
                return "processingInstruction";
            }
            case 3: {
                return "text";
            }
        }
        return "unknown";
    }

    @Override
    Navigator.XPathEx createXPathEx(String xpathString) throws TemplateModelException {
        try {
            return new DomXPathEx(xpathString);
        }
        catch (Exception e2) {
            throw new TemplateModelException(e2);
        }
    }

    private static final class DomXPathEx
    extends DOMXPath
    implements Navigator.XPathEx {
        DomXPathEx(String path) throws Exception {
            super(path);
        }

        @Override
        public List selectNodes(Object object, NamespaceContext namespaces) throws TemplateModelException {
            Context context = this.getContext(object);
            context.getContextSupport().setNamespaceContext(namespaces);
            try {
                return this.selectNodesForContext(context);
            }
            catch (Exception e2) {
                throw new TemplateModelException(e2);
            }
        }
    }
}

