/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.util;

import java.util.AbstractList;
import java.util.Arrays;

public final class CollisionCheckStack<E>
extends AbstractList<E> {
    private Object[] data;
    private int[] next;
    private int size = 0;
    private boolean latestPushResult = false;
    private boolean useIdentity = true;
    private final int[] initialHash = new int[17];

    public CollisionCheckStack() {
        this.data = new Object[16];
        this.next = new int[16];
    }

    public void setUseIdentity(boolean useIdentity) {
        this.useIdentity = useIdentity;
    }

    public boolean getUseIdentity() {
        return this.useIdentity;
    }

    public boolean getLatestPushResult() {
        return this.latestPushResult;
    }

    public boolean push(E o2) {
        if (this.data.length == this.size) {
            this.expandCapacity();
        }
        this.data[this.size] = o2;
        int hash = this.hash(o2);
        boolean r2 = this.findDuplicate(o2, hash);
        this.next[this.size] = this.initialHash[hash];
        this.initialHash[hash] = this.size + 1;
        ++this.size;
        this.latestPushResult = r2;
        return this.latestPushResult;
    }

    public void pushNocheck(E o2) {
        if (this.data.length == this.size) {
            this.expandCapacity();
        }
        this.data[this.size] = o2;
        this.next[this.size] = -1;
        ++this.size;
    }

    public boolean findDuplicate(E o2) {
        int hash = this.hash(o2);
        return this.findDuplicate(o2, hash);
    }

    @Override
    public E get(int index) {
        return (E)this.data[index];
    }

    @Override
    public int size() {
        return this.size;
    }

    private int hash(Object o2) {
        return ((this.useIdentity ? System.identityHashCode(o2) : o2.hashCode()) & Integer.MAX_VALUE) % this.initialHash.length;
    }

    public E pop() {
        --this.size;
        Object o2 = this.data[this.size];
        this.data[this.size] = null;
        int n2 = this.next[this.size];
        if (n2 >= 0) {
            int hash = this.hash(o2);
            assert (this.initialHash[hash] == this.size + 1);
            this.initialHash[hash] = n2;
        }
        return (E)o2;
    }

    public E peek() {
        return (E)this.data[this.size - 1];
    }

    private boolean findDuplicate(E o2, int hash) {
        int p2 = this.initialHash[hash];
        while (p2 != 0) {
            Object existing = this.data[--p2];
            if (this.useIdentity ? existing == o2 : o2.equals(existing)) {
                return true;
            }
            p2 = this.next[p2];
        }
        return false;
    }

    private void expandCapacity() {
        int oldSize = this.data.length;
        int newSize = oldSize * 2;
        Object[] d2 = new Object[newSize];
        int[] n2 = new int[newSize];
        System.arraycopy(this.data, 0, d2, 0, oldSize);
        System.arraycopy(this.next, 0, n2, 0, oldSize);
        this.data = d2;
        this.next = n2;
    }

    public void reset() {
        if (this.size > 0) {
            this.size = 0;
            Arrays.fill(this.initialHash, 0);
        }
    }

    public String getCycleString() {
        E x2;
        StringBuilder sb = new StringBuilder();
        int i2 = this.size() - 1;
        E obj = this.get(i2);
        sb.append(obj);
        do {
            sb.append(" -> ");
            x2 = this.get(--i2);
            sb.append(x2);
        } while (obj != x2);
        return sb.toString();
    }
}

